#ifndef _ACSErrTypeCommon_H_
#define _ACSErrTypeCommon_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "ACSErrTypeCommonC.h"

#include "acserrExceptionManager.h"

namespace ACSErrTypeCommon
{

class FileNotFoundCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = FileNotFound;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return FileNotFoundCompletion::m_shortDescription; }
	FileNotFoundCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	FileNotFoundCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	FileNotFoundCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	FileNotFoundCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	FileNotFoundCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	FileNotFoundCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setFileName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("FileName", value); }            				
	ACE_CString getFileName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("FileName");  }

	
};

class OutOfBoundsCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = OutOfBounds;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return OutOfBoundsCompletion::m_shortDescription; }
	OutOfBoundsCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	OutOfBoundsCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	OutOfBoundsCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	OutOfBoundsCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	OutOfBoundsCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	OutOfBoundsCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setMinValue(ACE_CString value){ getErrorTraceHelper()->setMemberValue("MinValue", value); }            				
	ACE_CString getMinValue (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("MinValue");  }

		void setMaxValue(ACE_CString value){ getErrorTraceHelper()->setMemberValue("MaxValue", value); }            				
	ACE_CString getMaxValue (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("MaxValue");  }

		void setRequestedValue(ACE_CString value){ getErrorTraceHelper()->setMemberValue("RequestedValue", value); }            				
	ACE_CString getRequestedValue (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("RequestedValue");  }

	
};

class IOErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = IOError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return IOErrorCompletion::m_shortDescription; }
	IOErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	IOErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	IOErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	IOErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	IOErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	IOErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class UnknownCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = Unknown;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return UnknownCompletion::m_shortDescription; }
	UnknownCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	UnknownCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnknownCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnknownCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnknownCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	UnknownCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class NoResourcesCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = NoResources;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return NoResourcesCompletion::m_shortDescription; }
	NoResourcesCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	NoResourcesCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NoResourcesCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NoResourcesCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NoResourcesCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	NoResourcesCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class MemoryFaultCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = MemoryFault;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return MemoryFaultCompletion::m_shortDescription; }
	MemoryFaultCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	MemoryFaultCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	MemoryFaultCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	MemoryFaultCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	MemoryFaultCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	MemoryFaultCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class CouldntCreateObjectCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = CouldntCreateObject;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CouldntCreateObjectCompletion::m_shortDescription; }
	CouldntCreateObjectCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CouldntCreateObjectCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CouldntCreateObjectCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CouldntCreateObjectCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CouldntCreateObjectCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CouldntCreateObjectCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class CouldntCreateThreadCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = CouldntCreateThread;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CouldntCreateThreadCompletion::m_shortDescription; }
	CouldntCreateThreadCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CouldntCreateThreadCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CouldntCreateThreadCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CouldntCreateThreadCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CouldntCreateThreadCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CouldntCreateThreadCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class CouldntAccessComponentCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = CouldntAccessComponent;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CouldntAccessComponentCompletion::m_shortDescription; }
	CouldntAccessComponentCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CouldntAccessComponentCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CouldntAccessComponentCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CouldntAccessComponentCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CouldntAccessComponentCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CouldntAccessComponentCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class CouldntAccessPropertyCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = CouldntAccessProperty;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CouldntAccessPropertyCompletion::m_shortDescription; }
	CouldntAccessPropertyCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CouldntAccessPropertyCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CouldntAccessPropertyCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CouldntAccessPropertyCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CouldntAccessPropertyCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CouldntAccessPropertyCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class CouldntPerformActionCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = CouldntPerformAction;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CouldntPerformActionCompletion::m_shortDescription; }
	CouldntPerformActionCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CouldntPerformActionCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CouldntPerformActionCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CouldntPerformActionCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CouldntPerformActionCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CouldntPerformActionCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class TypeNotFoundCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = TypeNotFound;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return TypeNotFoundCompletion::m_shortDescription; }
	TypeNotFoundCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TypeNotFoundCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TypeNotFoundCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TypeNotFoundCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TypeNotFoundCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TypeNotFoundCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class TypeNotSupportedCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = TypeNotSupported;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return TypeNotSupportedCompletion::m_shortDescription; }
	TypeNotSupportedCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TypeNotSupportedCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TypeNotSupportedCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TypeNotSupportedCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TypeNotSupportedCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TypeNotSupportedCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class CORBAProblemCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = CORBAProblem;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CORBAProblemCompletion::m_shortDescription; }
	CORBAProblemCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CORBAProblemCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CORBAProblemCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CORBAProblemCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CORBAProblemCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CORBAProblemCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setMinor(long value){ getErrorTraceHelper()->setMemberValue("Minor", value); }            				
	long getMinor (){ return getErrorTraceHelper()->getMemberValue<long>("Minor");  }

		void setCompletionStatus(long value){ getErrorTraceHelper()->setMemberValue("CompletionStatus", value); }            				
	long getCompletionStatus (){ return getErrorTraceHelper()->getMemberValue<long>("CompletionStatus");  }

		void setInfo(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Info", value); }            				
	ACE_CString getInfo (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Info");  }

	
};

class IllegalStateEventCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = IllegalStateEvent;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return IllegalStateEventCompletion::m_shortDescription; }
	IllegalStateEventCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	IllegalStateEventCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	IllegalStateEventCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	IllegalStateEventCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	IllegalStateEventCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	IllegalStateEventCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setEvent(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Event", value); }            				
	ACE_CString getEvent (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Event");  }

		void setState(ACE_CString value){ getErrorTraceHelper()->setMemberValue("State", value); }            				
	ACE_CString getState (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("State");  }

	
};

class NotImplementedCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = NotImplemented;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return NotImplementedCompletion::m_shortDescription; }
	NotImplementedCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	NotImplementedCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NotImplementedCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NotImplementedCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NotImplementedCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	NotImplementedCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setFeature(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Feature", value); }            				
	ACE_CString getFeature (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Feature");  }

	
};

class GenericErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = GenericError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return GenericErrorCompletion::m_shortDescription; }
	GenericErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	GenericErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	GenericErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	GenericErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	GenericErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	GenericErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setErrorDesc(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ErrorDesc", value); }            				
	ACE_CString getErrorDesc (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ErrorDesc");  }

	
};

class NullPointerCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = NullPointer;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return NullPointerCompletion::m_shortDescription; }
	NullPointerCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	NullPointerCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NullPointerCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NullPointerCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NullPointerCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	NullPointerCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setVariable(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Variable", value); }            				
	ACE_CString getVariable (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Variable");  }

	
};

class IllegalArgumentCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = IllegalArgument;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return IllegalArgumentCompletion::m_shortDescription; }
	IllegalArgumentCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	IllegalArgumentCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	IllegalArgumentCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	IllegalArgumentCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	IllegalArgumentCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	IllegalArgumentCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setVariable(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Variable", value); }            				
	ACE_CString getVariable (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Variable");  }

		void setValue(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Value", value); }            				
	ACE_CString getValue (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Value");  }

		void setErrorDesc(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ErrorDesc", value); }            				
	ACE_CString getErrorDesc (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ErrorDesc");  }

	
};

class BadParameterCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = BadParameter;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return BadParameterCompletion::m_shortDescription; }
	BadParameterCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	BadParameterCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	BadParameterCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	BadParameterCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	BadParameterCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	BadParameterCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setParameter(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Parameter", value); }            				
	ACE_CString getParameter (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Parameter");  }

		void setParameterValue(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ParameterValue", value); }            				
	ACE_CString getParameterValue (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ParameterValue");  }

		void setReason(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Reason", value); }            				
	ACE_CString getReason (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Reason");  }

	
};

class UnexpectedExceptionCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = UnexpectedException;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return UnexpectedExceptionCompletion::m_shortDescription; }
	UnexpectedExceptionCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	UnexpectedExceptionCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnexpectedExceptionCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnexpectedExceptionCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnexpectedExceptionCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	UnexpectedExceptionCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

	
};

class NotInitializedCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = NotInitialized;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return NotInitializedCompletion::m_shortDescription; }
	NotInitializedCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	NotInitializedCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NotInitializedCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NotInitializedCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NotInitializedCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	NotInitializedCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Name", value); }            				
	ACE_CString getName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Name");  }

	
};

class CannotLoadCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = CannotLoad;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CannotLoadCompletion::m_shortDescription; }
	CannotLoadCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CannotLoadCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotLoadCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotLoadCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotLoadCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CannotLoadCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setObjectName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ObjectName", value); }            				
	ACE_CString getObjectName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ObjectName");  }

	
};

class ParsingXMLProblemCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon; // = 10
	static const ACSErr::ErrorCode m_code = ParsingXMLProblem;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ParsingXMLProblemCompletion::m_shortDescription; }
	ParsingXMLProblemCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ParsingXMLProblemCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ParsingXMLProblemCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ParsingXMLProblemCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ParsingXMLProblemCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ParsingXMLProblemCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setXML(ACE_CString value){ getErrorTraceHelper()->setMemberValue("XML", value); }            				
	ACE_CString getXML (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("XML");  }

	
};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class ACSErrTypeCommonExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	ACSErrTypeCommonExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	ACSErrTypeCommonExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	ACSErrTypeCommonExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	ACSErrTypeCommonExImpl (ACSErrTypeCommon::ACSErrTypeCommonEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::ACSErrTypeCommonEx getACSErrTypeCommonEx () { return ACSErrTypeCommon::ACSErrTypeCommonEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class FileNotFoundExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = FileNotFound;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	FileNotFoundExImpl(const FileNotFoundExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<FileNotFoundExImpl&>(ex).getErrorTrace()) {}
		
	FileNotFoundExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	FileNotFoundExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	FileNotFoundExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	FileNotFoundExImpl (const ACSErrTypeCommon::FileNotFoundEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::FileNotFoundEx getFileNotFoundEx () { return ACSErrTypeCommon::FileNotFoundEx (getErrorTrace()); }
	
	template <class T >
	FileNotFoundExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setFileName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("FileName", value); }            				
	ACE_CString getFileName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("FileName");  }

	
};

class OutOfBoundsExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = OutOfBounds;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	OutOfBoundsExImpl(const OutOfBoundsExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<OutOfBoundsExImpl&>(ex).getErrorTrace()) {}
		
	OutOfBoundsExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	OutOfBoundsExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	OutOfBoundsExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	OutOfBoundsExImpl (const ACSErrTypeCommon::OutOfBoundsEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::OutOfBoundsEx getOutOfBoundsEx () { return ACSErrTypeCommon::OutOfBoundsEx (getErrorTrace()); }
	
	template <class T >
	OutOfBoundsExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setMinValue(ACE_CString value){ getErrorTraceHelper()->setMemberValue("MinValue", value); }            				
	ACE_CString getMinValue (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("MinValue");  }

		void setMaxValue(ACE_CString value){ getErrorTraceHelper()->setMemberValue("MaxValue", value); }            				
	ACE_CString getMaxValue (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("MaxValue");  }

		void setRequestedValue(ACE_CString value){ getErrorTraceHelper()->setMemberValue("RequestedValue", value); }            				
	ACE_CString getRequestedValue (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("RequestedValue");  }

	
};

class IOErrorExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = IOError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	IOErrorExImpl(const IOErrorExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<IOErrorExImpl&>(ex).getErrorTrace()) {}
		
	IOErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	IOErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	IOErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	IOErrorExImpl (const ACSErrTypeCommon::IOErrorEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::IOErrorEx getIOErrorEx () { return ACSErrTypeCommon::IOErrorEx (getErrorTrace()); }
	
	template <class T >
	IOErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class UnknownExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = Unknown;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	UnknownExImpl(const UnknownExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<UnknownExImpl&>(ex).getErrorTrace()) {}
		
	UnknownExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	UnknownExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UnknownExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UnknownExImpl (const ACSErrTypeCommon::UnknownEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::UnknownEx getUnknownEx () { return ACSErrTypeCommon::UnknownEx (getErrorTrace()); }
	
	template <class T >
	UnknownExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class NoResourcesExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = NoResources;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	NoResourcesExImpl(const NoResourcesExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<NoResourcesExImpl&>(ex).getErrorTrace()) {}
		
	NoResourcesExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	NoResourcesExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NoResourcesExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NoResourcesExImpl (const ACSErrTypeCommon::NoResourcesEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::NoResourcesEx getNoResourcesEx () { return ACSErrTypeCommon::NoResourcesEx (getErrorTrace()); }
	
	template <class T >
	NoResourcesExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class MemoryFaultExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = MemoryFault;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	MemoryFaultExImpl(const MemoryFaultExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<MemoryFaultExImpl&>(ex).getErrorTrace()) {}
		
	MemoryFaultExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	MemoryFaultExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	MemoryFaultExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	MemoryFaultExImpl (const ACSErrTypeCommon::MemoryFaultEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::MemoryFaultEx getMemoryFaultEx () { return ACSErrTypeCommon::MemoryFaultEx (getErrorTrace()); }
	
	template <class T >
	MemoryFaultExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class CouldntCreateObjectExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = CouldntCreateObject;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CouldntCreateObjectExImpl(const CouldntCreateObjectExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<CouldntCreateObjectExImpl&>(ex).getErrorTrace()) {}
		
	CouldntCreateObjectExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CouldntCreateObjectExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CouldntCreateObjectExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CouldntCreateObjectExImpl (const ACSErrTypeCommon::CouldntCreateObjectEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::CouldntCreateObjectEx getCouldntCreateObjectEx () { return ACSErrTypeCommon::CouldntCreateObjectEx (getErrorTrace()); }
	
	template <class T >
	CouldntCreateObjectExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class CouldntCreateThreadExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = CouldntCreateThread;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CouldntCreateThreadExImpl(const CouldntCreateThreadExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<CouldntCreateThreadExImpl&>(ex).getErrorTrace()) {}
		
	CouldntCreateThreadExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CouldntCreateThreadExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CouldntCreateThreadExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CouldntCreateThreadExImpl (const ACSErrTypeCommon::CouldntCreateThreadEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::CouldntCreateThreadEx getCouldntCreateThreadEx () { return ACSErrTypeCommon::CouldntCreateThreadEx (getErrorTrace()); }
	
	template <class T >
	CouldntCreateThreadExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class CouldntAccessComponentExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = CouldntAccessComponent;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CouldntAccessComponentExImpl(const CouldntAccessComponentExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<CouldntAccessComponentExImpl&>(ex).getErrorTrace()) {}
		
	CouldntAccessComponentExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CouldntAccessComponentExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CouldntAccessComponentExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CouldntAccessComponentExImpl (const ACSErrTypeCommon::CouldntAccessComponentEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::CouldntAccessComponentEx getCouldntAccessComponentEx () { return ACSErrTypeCommon::CouldntAccessComponentEx (getErrorTrace()); }
	
	template <class T >
	CouldntAccessComponentExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class CouldntAccessPropertyExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = CouldntAccessProperty;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CouldntAccessPropertyExImpl(const CouldntAccessPropertyExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<CouldntAccessPropertyExImpl&>(ex).getErrorTrace()) {}
		
	CouldntAccessPropertyExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CouldntAccessPropertyExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CouldntAccessPropertyExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CouldntAccessPropertyExImpl (const ACSErrTypeCommon::CouldntAccessPropertyEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::CouldntAccessPropertyEx getCouldntAccessPropertyEx () { return ACSErrTypeCommon::CouldntAccessPropertyEx (getErrorTrace()); }
	
	template <class T >
	CouldntAccessPropertyExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class CouldntPerformActionExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = CouldntPerformAction;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CouldntPerformActionExImpl(const CouldntPerformActionExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<CouldntPerformActionExImpl&>(ex).getErrorTrace()) {}
		
	CouldntPerformActionExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CouldntPerformActionExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CouldntPerformActionExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CouldntPerformActionExImpl (const ACSErrTypeCommon::CouldntPerformActionEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::CouldntPerformActionEx getCouldntPerformActionEx () { return ACSErrTypeCommon::CouldntPerformActionEx (getErrorTrace()); }
	
	template <class T >
	CouldntPerformActionExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class TypeNotFoundExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = TypeNotFound;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	TypeNotFoundExImpl(const TypeNotFoundExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<TypeNotFoundExImpl&>(ex).getErrorTrace()) {}
		
	TypeNotFoundExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TypeNotFoundExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TypeNotFoundExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TypeNotFoundExImpl (const ACSErrTypeCommon::TypeNotFoundEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::TypeNotFoundEx getTypeNotFoundEx () { return ACSErrTypeCommon::TypeNotFoundEx (getErrorTrace()); }
	
	template <class T >
	TypeNotFoundExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class TypeNotSupportedExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = TypeNotSupported;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	TypeNotSupportedExImpl(const TypeNotSupportedExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<TypeNotSupportedExImpl&>(ex).getErrorTrace()) {}
		
	TypeNotSupportedExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TypeNotSupportedExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TypeNotSupportedExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TypeNotSupportedExImpl (const ACSErrTypeCommon::TypeNotSupportedEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::TypeNotSupportedEx getTypeNotSupportedEx () { return ACSErrTypeCommon::TypeNotSupportedEx (getErrorTrace()); }
	
	template <class T >
	TypeNotSupportedExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class CORBAProblemExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = CORBAProblem;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CORBAProblemExImpl(const CORBAProblemExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<CORBAProblemExImpl&>(ex).getErrorTrace()) {}
		
	CORBAProblemExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CORBAProblemExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CORBAProblemExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CORBAProblemExImpl (const ACSErrTypeCommon::CORBAProblemEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::CORBAProblemEx getCORBAProblemEx () { return ACSErrTypeCommon::CORBAProblemEx (getErrorTrace()); }
	
	template <class T >
	CORBAProblemExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setMinor(long value){ getErrorTraceHelper()->setMemberValue("Minor", value); }            				
	long getMinor (){ return getErrorTraceHelper()->getMemberValue<long>("Minor");  }

		void setCompletionStatus(long value){ getErrorTraceHelper()->setMemberValue("CompletionStatus", value); }            				
	long getCompletionStatus (){ return getErrorTraceHelper()->getMemberValue<long>("CompletionStatus");  }

		void setInfo(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Info", value); }            				
	ACE_CString getInfo (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Info");  }

	
};

class IllegalStateEventExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = IllegalStateEvent;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	IllegalStateEventExImpl(const IllegalStateEventExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<IllegalStateEventExImpl&>(ex).getErrorTrace()) {}
		
	IllegalStateEventExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	IllegalStateEventExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	IllegalStateEventExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	IllegalStateEventExImpl (const ACSErrTypeCommon::IllegalStateEventEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::IllegalStateEventEx getIllegalStateEventEx () { return ACSErrTypeCommon::IllegalStateEventEx (getErrorTrace()); }
	
	template <class T >
	IllegalStateEventExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setEvent(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Event", value); }            				
	ACE_CString getEvent (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Event");  }

		void setState(ACE_CString value){ getErrorTraceHelper()->setMemberValue("State", value); }            				
	ACE_CString getState (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("State");  }

	
};

class NotImplementedExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = NotImplemented;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	NotImplementedExImpl(const NotImplementedExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<NotImplementedExImpl&>(ex).getErrorTrace()) {}
		
	NotImplementedExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	NotImplementedExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NotImplementedExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NotImplementedExImpl (const ACSErrTypeCommon::NotImplementedEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::NotImplementedEx getNotImplementedEx () { return ACSErrTypeCommon::NotImplementedEx (getErrorTrace()); }
	
	template <class T >
	NotImplementedExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setFeature(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Feature", value); }            				
	ACE_CString getFeature (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Feature");  }

	
};

class GenericErrorExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = GenericError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	GenericErrorExImpl(const GenericErrorExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<GenericErrorExImpl&>(ex).getErrorTrace()) {}
		
	GenericErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	GenericErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	GenericErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	GenericErrorExImpl (const ACSErrTypeCommon::GenericErrorEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::GenericErrorEx getGenericErrorEx () { return ACSErrTypeCommon::GenericErrorEx (getErrorTrace()); }
	
	template <class T >
	GenericErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setErrorDesc(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ErrorDesc", value); }            				
	ACE_CString getErrorDesc (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ErrorDesc");  }

	
};

class NullPointerExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = NullPointer;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	NullPointerExImpl(const NullPointerExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<NullPointerExImpl&>(ex).getErrorTrace()) {}
		
	NullPointerExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	NullPointerExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NullPointerExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NullPointerExImpl (const ACSErrTypeCommon::NullPointerEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::NullPointerEx getNullPointerEx () { return ACSErrTypeCommon::NullPointerEx (getErrorTrace()); }
	
	template <class T >
	NullPointerExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setVariable(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Variable", value); }            				
	ACE_CString getVariable (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Variable");  }

	
};

class IllegalArgumentExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = IllegalArgument;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	IllegalArgumentExImpl(const IllegalArgumentExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<IllegalArgumentExImpl&>(ex).getErrorTrace()) {}
		
	IllegalArgumentExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	IllegalArgumentExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	IllegalArgumentExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	IllegalArgumentExImpl (const ACSErrTypeCommon::IllegalArgumentEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::IllegalArgumentEx getIllegalArgumentEx () { return ACSErrTypeCommon::IllegalArgumentEx (getErrorTrace()); }
	
	template <class T >
	IllegalArgumentExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setVariable(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Variable", value); }            				
	ACE_CString getVariable (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Variable");  }

		void setValue(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Value", value); }            				
	ACE_CString getValue (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Value");  }

		void setErrorDesc(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ErrorDesc", value); }            				
	ACE_CString getErrorDesc (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ErrorDesc");  }

	
};

class BadParameterExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = BadParameter;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	BadParameterExImpl(const BadParameterExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<BadParameterExImpl&>(ex).getErrorTrace()) {}
		
	BadParameterExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	BadParameterExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	BadParameterExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	BadParameterExImpl (const ACSErrTypeCommon::BadParameterEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::BadParameterEx getBadParameterEx () { return ACSErrTypeCommon::BadParameterEx (getErrorTrace()); }
	
	template <class T >
	BadParameterExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setParameter(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Parameter", value); }            				
	ACE_CString getParameter (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Parameter");  }

		void setParameterValue(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ParameterValue", value); }            				
	ACE_CString getParameterValue (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ParameterValue");  }

		void setReason(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Reason", value); }            				
	ACE_CString getReason (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Reason");  }

	
};

class UnexpectedExceptionExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = UnexpectedException;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	UnexpectedExceptionExImpl(const UnexpectedExceptionExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<UnexpectedExceptionExImpl&>(ex).getErrorTrace()) {}
		
	UnexpectedExceptionExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	UnexpectedExceptionExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UnexpectedExceptionExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UnexpectedExceptionExImpl (const ACSErrTypeCommon::UnexpectedExceptionEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::UnexpectedExceptionEx getUnexpectedExceptionEx () { return ACSErrTypeCommon::UnexpectedExceptionEx (getErrorTrace()); }
	
	template <class T >
	UnexpectedExceptionExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


	
};

class NotInitializedExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = NotInitialized;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	NotInitializedExImpl(const NotInitializedExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<NotInitializedExImpl&>(ex).getErrorTrace()) {}
		
	NotInitializedExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	NotInitializedExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NotInitializedExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NotInitializedExImpl (const ACSErrTypeCommon::NotInitializedEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::NotInitializedEx getNotInitializedEx () { return ACSErrTypeCommon::NotInitializedEx (getErrorTrace()); }
	
	template <class T >
	NotInitializedExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Name", value); }            				
	ACE_CString getName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Name");  }

	
};

class CannotLoadExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = CannotLoad;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CannotLoadExImpl(const CannotLoadExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<CannotLoadExImpl&>(ex).getErrorTrace()) {}
		
	CannotLoadExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CannotLoadExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotLoadExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotLoadExImpl (const ACSErrTypeCommon::CannotLoadEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::CannotLoadEx getCannotLoadEx () { return ACSErrTypeCommon::CannotLoadEx (getErrorTrace()); }
	
	template <class T >
	CannotLoadExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setObjectName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ObjectName", value); }            				
	ACE_CString getObjectName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ObjectName");  }

	
};

class ParsingXMLProblemExImpl: public ACSErrTypeCommonExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCommon;
	static const ACSErr::ErrorCode m_code = ParsingXMLProblem;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ParsingXMLProblemExImpl(const ParsingXMLProblemExImpl& ex) :
			ACSErrTypeCommonExImpl(const_cast<ParsingXMLProblemExImpl&>(ex).getErrorTrace()) {}
		
	ParsingXMLProblemExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ParsingXMLProblemExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ParsingXMLProblemExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ParsingXMLProblemExImpl (const ACSErrTypeCommon::ParsingXMLProblemEx & ex) : 
			ACSErrTypeCommonExImpl(ex.errorTrace) {}
			
	ACSErrTypeCommon::ParsingXMLProblemEx getParsingXMLProblemEx () { return ACSErrTypeCommon::ParsingXMLProblemEx (getErrorTrace()); }
	
	template <class T >
	ParsingXMLProblemExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCommonExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setXML(ACE_CString value){ getErrorTraceHelper()->setMemberValue("XML", value); }            				
	ACE_CString getXML (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("XML");  }

	
};

}

#endif
