#ifndef _ACSErrTypeCORBA_H_
#define _ACSErrTypeCORBA_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "ACSErrTypeCORBAC.h"

#include "acserrExceptionManager.h"

namespace ACSErrTypeCORBA
{

class FailedToResolveServiceCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCORBA; // = 15
	static const ACSErr::ErrorCode m_code = FailedToResolveService;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return FailedToResolveServiceCompletion::m_shortDescription; }
	FailedToResolveServiceCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	FailedToResolveServiceCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	FailedToResolveServiceCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	FailedToResolveServiceCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	FailedToResolveServiceCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	FailedToResolveServiceCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class CORBAReferenceNilCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCORBA; // = 15
	static const ACSErr::ErrorCode m_code = CORBAReferenceNil;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CORBAReferenceNilCompletion::m_shortDescription; }
	CORBAReferenceNilCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CORBAReferenceNilCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CORBAReferenceNilCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CORBAReferenceNilCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CORBAReferenceNilCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CORBAReferenceNilCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

			void setVariable(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Variable", value); }            				
	ACE_CString getVariable (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Variable");  }

	
};

class NarrowFailedCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCORBA; // = 15
	static const ACSErr::ErrorCode m_code = NarrowFailed;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return NarrowFailedCompletion::m_shortDescription; }
	NarrowFailedCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	NarrowFailedCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NarrowFailedCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NarrowFailedCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NarrowFailedCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	NarrowFailedCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

			void setNarrowType(ACE_CString value){ getErrorTraceHelper()->setMemberValue("NarrowType", value); }            				
	ACE_CString getNarrowType (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("NarrowType");  }

	
};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class ACSErrTypeCORBAExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	ACSErrTypeCORBAExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	ACSErrTypeCORBAExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	ACSErrTypeCORBAExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	ACSErrTypeCORBAExImpl (ACSErrTypeCORBA::ACSErrTypeCORBAEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	ACSErrTypeCORBA::ACSErrTypeCORBAEx getACSErrTypeCORBAEx () { return ACSErrTypeCORBA::ACSErrTypeCORBAEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class FailedToResolveServiceExImpl: public ACSErrTypeCORBAExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCORBA;
	static const ACSErr::ErrorCode m_code = FailedToResolveService;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	FailedToResolveServiceExImpl(const FailedToResolveServiceExImpl& ex) :
			ACSErrTypeCORBAExImpl(const_cast<FailedToResolveServiceExImpl&>(ex).getErrorTrace()) {}
		
	FailedToResolveServiceExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCORBAExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	FailedToResolveServiceExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCORBAExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	FailedToResolveServiceExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCORBAExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	FailedToResolveServiceExImpl (const ACSErrTypeCORBA::FailedToResolveServiceEx & ex) : 
			ACSErrTypeCORBAExImpl(ex.errorTrace) {}
			
	ACSErrTypeCORBA::FailedToResolveServiceEx getFailedToResolveServiceEx () { return ACSErrTypeCORBA::FailedToResolveServiceEx (getErrorTrace()); }
	
	template <class T >
	FailedToResolveServiceExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCORBAExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class CORBAReferenceNilExImpl: public ACSErrTypeCORBAExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCORBA;
	static const ACSErr::ErrorCode m_code = CORBAReferenceNil;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CORBAReferenceNilExImpl(const CORBAReferenceNilExImpl& ex) :
			ACSErrTypeCORBAExImpl(const_cast<CORBAReferenceNilExImpl&>(ex).getErrorTrace()) {}
		
	CORBAReferenceNilExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCORBAExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CORBAReferenceNilExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCORBAExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CORBAReferenceNilExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCORBAExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CORBAReferenceNilExImpl (const ACSErrTypeCORBA::CORBAReferenceNilEx & ex) : 
			ACSErrTypeCORBAExImpl(ex.errorTrace) {}
			
	ACSErrTypeCORBA::CORBAReferenceNilEx getCORBAReferenceNilEx () { return ACSErrTypeCORBA::CORBAReferenceNilEx (getErrorTrace()); }
	
	template <class T >
	CORBAReferenceNilExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCORBAExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


			void setVariable(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Variable", value); }            				
	ACE_CString getVariable (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Variable");  }

	
};

class NarrowFailedExImpl: public ACSErrTypeCORBAExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCORBA;
	static const ACSErr::ErrorCode m_code = NarrowFailed;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	NarrowFailedExImpl(const NarrowFailedExImpl& ex) :
			ACSErrTypeCORBAExImpl(const_cast<NarrowFailedExImpl&>(ex).getErrorTrace()) {}
		
	NarrowFailedExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCORBAExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	NarrowFailedExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCORBAExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NarrowFailedExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCORBAExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NarrowFailedExImpl (const ACSErrTypeCORBA::NarrowFailedEx & ex) : 
			ACSErrTypeCORBAExImpl(ex.errorTrace) {}
			
	ACSErrTypeCORBA::NarrowFailedEx getNarrowFailedEx () { return ACSErrTypeCORBA::NarrowFailedEx (getErrorTrace()); }
	
	template <class T >
	NarrowFailedExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCORBAExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


			void setNarrowType(ACE_CString value){ getErrorTraceHelper()->setMemberValue("NarrowType", value); }            				
	ACE_CString getNarrowType (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("NarrowType");  }

	
};

}

#endif
