#ifndef _ACSErrTicsTCorr_H_
#define _ACSErrTicsTCorr_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "ACSErrTicsTCorrC.h"

#include "acserrExceptionManager.h"

namespace ACSErrTicsTCorr
{

class AnyTICSTCorrErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTicsTCorr; // = 14
	static const ACSErr::ErrorCode m_code = AnyTICSTCorrError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AnyTICSTCorrErrorCompletion::m_shortDescription; }
	AnyTICSTCorrErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AnyTICSTCorrErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AnyTICSTCorrErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AnyTICSTCorrErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AnyTICSTCorrErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AnyTICSTCorrErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class ACSErrTicsTCorrExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	ACSErrTicsTCorrExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	ACSErrTicsTCorrExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	ACSErrTicsTCorrExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	ACSErrTicsTCorrExImpl (ACSErrTicsTCorr::ACSErrTicsTCorrEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	ACSErrTicsTCorr::ACSErrTicsTCorrEx getACSErrTicsTCorrEx () { return ACSErrTicsTCorr::ACSErrTicsTCorrEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class AnyTICSTCorrErrorExImpl: public ACSErrTicsTCorrExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTicsTCorr;
	static const ACSErr::ErrorCode m_code = AnyTICSTCorrError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AnyTICSTCorrErrorExImpl(const AnyTICSTCorrErrorExImpl& ex) :
			ACSErrTicsTCorrExImpl(const_cast<AnyTICSTCorrErrorExImpl&>(ex).getErrorTrace()) {}
		
	AnyTICSTCorrErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTicsTCorrExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AnyTICSTCorrErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTicsTCorrExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AnyTICSTCorrErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTicsTCorrExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AnyTICSTCorrErrorExImpl (const ACSErrTicsTCorr::AnyTICSTCorrErrorEx & ex) : 
			ACSErrTicsTCorrExImpl(ex.errorTrace) {}
			
	ACSErrTicsTCorr::AnyTICSTCorrErrorEx getAnyTICSTCorrErrorEx () { return ACSErrTicsTCorr::AnyTICSTCorrErrorEx (getErrorTrace()); }
	
	template <class T >
	AnyTICSTCorrErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTicsTCorrExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

}

#endif
