#ifndef _ACSErrTICS_H_
#define _ACSErrTICS_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "ACSErrTICSC.h"

#include "acserrExceptionManager.h"

namespace ACSErrTICS
{

class AnyTICSErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTICS; // = 13
	static const ACSErr::ErrorCode m_code = AnyTICSError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AnyTICSErrorCompletion::m_shortDescription; }
	AnyTICSErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AnyTICSErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AnyTICSErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AnyTICSErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AnyTICSErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AnyTICSErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class ACSErrTICSExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	ACSErrTICSExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	ACSErrTICSExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	ACSErrTICSExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	ACSErrTICSExImpl (ACSErrTICS::ACSErrTICSEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	ACSErrTICS::ACSErrTICSEx getACSErrTICSEx () { return ACSErrTICS::ACSErrTICSEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class AnyTICSErrorExImpl: public ACSErrTICSExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTICS;
	static const ACSErr::ErrorCode m_code = AnyTICSError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AnyTICSErrorExImpl(const AnyTICSErrorExImpl& ex) :
			ACSErrTICSExImpl(const_cast<AnyTICSErrorExImpl&>(ex).getErrorTrace()) {}
		
	AnyTICSErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTICSExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AnyTICSErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTICSExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AnyTICSErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTICSExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AnyTICSErrorExImpl (const ACSErrTICS::AnyTICSErrorEx & ex) : 
			ACSErrTICSExImpl(ex.errorTrace) {}
			
	ACSErrTICS::AnyTICSErrorEx getAnyTICSErrorEx () { return ACSErrTICS::AnyTICSErrorEx (getErrorTrace()); }
	
	template <class T >
	AnyTICSErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTICSExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

}

#endif
