#ifndef _ACSBulkDataStatus_H_
#define _ACSBulkDataStatus_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "ACSBulkDataStatusC.h"

#include "acserrExceptionManager.h"

namespace ACSBulkDataStatus
{

class AVCbReadyCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataStatus; // = 54
	static const ACSErr::ErrorCode m_code = AVCbReady;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVCbReadyCompletion::m_shortDescription; }
	AVCbReadyCompletion () : ACSErr::CompletionImpl(m_etype, m_code) {}				
 };
 
class AVCbWorkingCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataStatus; // = 54
	static const ACSErr::ErrorCode m_code = AVCbWorking;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVCbWorkingCompletion::m_shortDescription; }
	AVCbWorkingCompletion () : ACSErr::CompletionImpl(m_etype, m_code) {}				
 };
 
class AVCbTimeoutCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataStatus; // = 54
	static const ACSErr::ErrorCode m_code = AVCbTimeout;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVCbTimeoutCompletion::m_shortDescription; }
	AVCbTimeoutCompletion () : ACSErr::CompletionImpl(m_etype, m_code) {}				
 };
 
class AVCbWorkingTimeoutCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataStatus; // = 54
	static const ACSErr::ErrorCode m_code = AVCbWorkingTimeout;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVCbWorkingTimeoutCompletion::m_shortDescription; }
	AVCbWorkingTimeoutCompletion () : ACSErr::CompletionImpl(m_etype, m_code) {}				
 };
 
class AVCbNotAvailableCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataStatus; // = 54
	static const ACSErr::ErrorCode m_code = AVCbNotAvailable;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVCbNotAvailableCompletion::m_shortDescription; }
	AVCbNotAvailableCompletion () : ACSErr::CompletionImpl(m_etype, m_code) {}				
 };
 
class AVCbErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataStatus; // = 54
	static const ACSErr::ErrorCode m_code = AVCbError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVCbErrorCompletion::m_shortDescription; }
	AVCbErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVCbErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVCbErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVCbErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVCbErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVCbErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class ACSBulkDataStatusExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	ACSBulkDataStatusExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	ACSBulkDataStatusExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	ACSBulkDataStatusExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	ACSBulkDataStatusExImpl (ACSBulkDataStatus::ACSBulkDataStatusEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	ACSBulkDataStatus::ACSBulkDataStatusEx getACSBulkDataStatusEx () { return ACSBulkDataStatus::ACSBulkDataStatusEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class AVCbErrorExImpl: public ACSBulkDataStatusExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataStatus;
	static const ACSErr::ErrorCode m_code = AVCbError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVCbErrorExImpl(const AVCbErrorExImpl& ex) :
			ACSBulkDataStatusExImpl(const_cast<AVCbErrorExImpl&>(ex).getErrorTrace()) {}
		
	AVCbErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataStatusExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVCbErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataStatusExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVCbErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataStatusExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVCbErrorExImpl (const ACSBulkDataStatus::AVCbErrorEx & ex) : 
			ACSBulkDataStatusExImpl(ex.errorTrace) {}
			
	ACSBulkDataStatus::AVCbErrorEx getAVCbErrorEx () { return ACSBulkDataStatus::AVCbErrorEx (getErrorTrace()); }
	
	template <class T >
	AVCbErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataStatusExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

}

#endif
