#ifndef _ACSBulkDataError_H_
#define _ACSBulkDataError_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "ACSBulkDataErrorC.h"

#include "acserrExceptionManager.h"

namespace ACSBulkDataError
{

class AVFlowEndpointErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVFlowEndpointError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVFlowEndpointErrorCompletion::m_shortDescription; }
	AVFlowEndpointErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVFlowEndpointErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVFlowEndpointErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVFlowEndpointErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVFlowEndpointErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVFlowEndpointErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVStreamEndpointErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVStreamEndpointError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVStreamEndpointErrorCompletion::m_shortDescription; }
	AVStreamEndpointErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVStreamEndpointErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVStreamEndpointErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVStreamEndpointErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVStreamEndpointErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVStreamEndpointErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVStreamBindErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVStreamBindError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVStreamBindErrorCompletion::m_shortDescription; }
	AVStreamBindErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVStreamBindErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVStreamBindErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVStreamBindErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVStreamBindErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVStreamBindErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVSendFrameErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVSendFrameError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVSendFrameErrorCompletion::m_shortDescription; }
	AVSendFrameErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVSendFrameErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVSendFrameErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVSendFrameErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVSendFrameErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVSendFrameErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVCouldNotOpenFileCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVCouldNotOpenFile;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVCouldNotOpenFileCompletion::m_shortDescription; }
	AVCouldNotOpenFileCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVCouldNotOpenFileCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVCouldNotOpenFileCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVCouldNotOpenFileCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVCouldNotOpenFileCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVCouldNotOpenFileCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVObjectNotFoundCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVObjectNotFound;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVObjectNotFoundCompletion::m_shortDescription; }
	AVObjectNotFoundCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVObjectNotFoundCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVObjectNotFoundCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVObjectNotFoundCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVObjectNotFoundCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVObjectNotFoundCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVInitErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVInitError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVInitErrorCompletion::m_shortDescription; }
	AVInitErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVInitErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVInitErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVInitErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVInitErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVInitErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVCallbackErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVCallbackError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVCallbackErrorCompletion::m_shortDescription; }
	AVCallbackErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVCallbackErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVCallbackErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVCallbackErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVCallbackErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVCallbackErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVProtocolErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVProtocolError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVProtocolErrorCompletion::m_shortDescription; }
	AVProtocolErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVProtocolErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVProtocolErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVProtocolErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVProtocolErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVProtocolErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVInvalidFlowNumberCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVInvalidFlowNumber;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVInvalidFlowNumberCompletion::m_shortDescription; }
	AVInvalidFlowNumberCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVInvalidFlowNumberCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVInvalidFlowNumberCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVInvalidFlowNumberCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVInvalidFlowNumberCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVInvalidFlowNumberCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVConnectErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVConnectError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVConnectErrorCompletion::m_shortDescription; }
	AVConnectErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVConnectErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVConnectErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVConnectErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVConnectErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVConnectErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVDisconnectErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVDisconnectError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVDisconnectErrorCompletion::m_shortDescription; }
	AVDisconnectErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVDisconnectErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVDisconnectErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVDisconnectErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVDisconnectErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVDisconnectErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVStartSendErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVStartSendError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVStartSendErrorCompletion::m_shortDescription; }
	AVStartSendErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVStartSendErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVStartSendErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVStartSendErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVStartSendErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVStartSendErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVPaceDataErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVPaceDataError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVPaceDataErrorCompletion::m_shortDescription; }
	AVPaceDataErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVPaceDataErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVPaceDataErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVPaceDataErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVPaceDataErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVPaceDataErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVStopSendErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVStopSendError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVStopSendErrorCompletion::m_shortDescription; }
	AVStopSendErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVStopSendErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVStopSendErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVStopSendErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVStopSendErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVStopSendErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVOpenReceiverErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVOpenReceiverError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVOpenReceiverErrorCompletion::m_shortDescription; }
	AVOpenReceiverErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVOpenReceiverErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVOpenReceiverErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVOpenReceiverErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVOpenReceiverErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVOpenReceiverErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVReceiverConfigErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVReceiverConfigError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVReceiverConfigErrorCompletion::m_shortDescription; }
	AVReceiverConfigErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVReceiverConfigErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVReceiverConfigErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVReceiverConfigErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVReceiverConfigErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVReceiverConfigErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVCloseReceiverErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVCloseReceiverError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVCloseReceiverErrorCompletion::m_shortDescription; }
	AVCloseReceiverErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVCloseReceiverErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVCloseReceiverErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVCloseReceiverErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVCloseReceiverErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVCloseReceiverErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVCbFlowTimeoutCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVCbFlowTimeout;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVCbFlowTimeoutCompletion::m_shortDescription; }
	AVCbFlowTimeoutCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVCbFlowTimeoutCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVCbFlowTimeoutCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVCbFlowTimeoutCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVCbFlowTimeoutCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVCbFlowTimeoutCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVSetReceiverNameErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVSetReceiverNameError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVSetReceiverNameErrorCompletion::m_shortDescription; }
	AVSetReceiverNameErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVSetReceiverNameErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVSetReceiverNameErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVSetReceiverNameErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVSetReceiverNameErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVSetReceiverNameErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVSetReceiverErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVSetReceiverError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVSetReceiverErrorCompletion::m_shortDescription; }
	AVSetReceiverErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVSetReceiverErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVSetReceiverErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVSetReceiverErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVSetReceiverErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVSetReceiverErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVNotificationMechanismErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVNotificationMechanismError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVNotificationMechanismErrorCompletion::m_shortDescription; }
	AVNotificationMechanismErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVNotificationMechanismErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVNotificationMechanismErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVNotificationMechanismErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVNotificationMechanismErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVNotificationMechanismErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVFlowNumbersNotMatchingErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVFlowNumbersNotMatchingError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVFlowNumbersNotMatchingErrorCompletion::m_shortDescription; }
	AVFlowNumbersNotMatchingErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVFlowNumbersNotMatchingErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVFlowNumbersNotMatchingErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVFlowNumbersNotMatchingErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVFlowNumbersNotMatchingErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVFlowNumbersNotMatchingErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AVCDBTimeoutErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError; // = 53
	static const ACSErr::ErrorCode m_code = AVCDBTimeoutError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AVCDBTimeoutErrorCompletion::m_shortDescription; }
	AVCDBTimeoutErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AVCDBTimeoutErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVCDBTimeoutErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVCDBTimeoutErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AVCDBTimeoutErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AVCDBTimeoutErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class ACSBulkDataErrorExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	ACSBulkDataErrorExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	ACSBulkDataErrorExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	ACSBulkDataErrorExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	ACSBulkDataErrorExImpl (ACSBulkDataError::ACSBulkDataErrorEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::ACSBulkDataErrorEx getACSBulkDataErrorEx () { return ACSBulkDataError::ACSBulkDataErrorEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class AVFlowEndpointErrorExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVFlowEndpointError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVFlowEndpointErrorExImpl(const AVFlowEndpointErrorExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVFlowEndpointErrorExImpl&>(ex).getErrorTrace()) {}
		
	AVFlowEndpointErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVFlowEndpointErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVFlowEndpointErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVFlowEndpointErrorExImpl (const ACSBulkDataError::AVFlowEndpointErrorEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVFlowEndpointErrorEx getAVFlowEndpointErrorEx () { return ACSBulkDataError::AVFlowEndpointErrorEx (getErrorTrace()); }
	
	template <class T >
	AVFlowEndpointErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVStreamEndpointErrorExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVStreamEndpointError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVStreamEndpointErrorExImpl(const AVStreamEndpointErrorExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVStreamEndpointErrorExImpl&>(ex).getErrorTrace()) {}
		
	AVStreamEndpointErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVStreamEndpointErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVStreamEndpointErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVStreamEndpointErrorExImpl (const ACSBulkDataError::AVStreamEndpointErrorEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVStreamEndpointErrorEx getAVStreamEndpointErrorEx () { return ACSBulkDataError::AVStreamEndpointErrorEx (getErrorTrace()); }
	
	template <class T >
	AVStreamEndpointErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVStreamBindErrorExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVStreamBindError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVStreamBindErrorExImpl(const AVStreamBindErrorExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVStreamBindErrorExImpl&>(ex).getErrorTrace()) {}
		
	AVStreamBindErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVStreamBindErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVStreamBindErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVStreamBindErrorExImpl (const ACSBulkDataError::AVStreamBindErrorEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVStreamBindErrorEx getAVStreamBindErrorEx () { return ACSBulkDataError::AVStreamBindErrorEx (getErrorTrace()); }
	
	template <class T >
	AVStreamBindErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVSendFrameErrorExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVSendFrameError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVSendFrameErrorExImpl(const AVSendFrameErrorExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVSendFrameErrorExImpl&>(ex).getErrorTrace()) {}
		
	AVSendFrameErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVSendFrameErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVSendFrameErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVSendFrameErrorExImpl (const ACSBulkDataError::AVSendFrameErrorEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVSendFrameErrorEx getAVSendFrameErrorEx () { return ACSBulkDataError::AVSendFrameErrorEx (getErrorTrace()); }
	
	template <class T >
	AVSendFrameErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVCouldNotOpenFileExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVCouldNotOpenFile;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVCouldNotOpenFileExImpl(const AVCouldNotOpenFileExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVCouldNotOpenFileExImpl&>(ex).getErrorTrace()) {}
		
	AVCouldNotOpenFileExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVCouldNotOpenFileExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVCouldNotOpenFileExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVCouldNotOpenFileExImpl (const ACSBulkDataError::AVCouldNotOpenFileEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVCouldNotOpenFileEx getAVCouldNotOpenFileEx () { return ACSBulkDataError::AVCouldNotOpenFileEx (getErrorTrace()); }
	
	template <class T >
	AVCouldNotOpenFileExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVObjectNotFoundExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVObjectNotFound;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVObjectNotFoundExImpl(const AVObjectNotFoundExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVObjectNotFoundExImpl&>(ex).getErrorTrace()) {}
		
	AVObjectNotFoundExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVObjectNotFoundExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVObjectNotFoundExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVObjectNotFoundExImpl (const ACSBulkDataError::AVObjectNotFoundEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVObjectNotFoundEx getAVObjectNotFoundEx () { return ACSBulkDataError::AVObjectNotFoundEx (getErrorTrace()); }
	
	template <class T >
	AVObjectNotFoundExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVInitErrorExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVInitError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVInitErrorExImpl(const AVInitErrorExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVInitErrorExImpl&>(ex).getErrorTrace()) {}
		
	AVInitErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVInitErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVInitErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVInitErrorExImpl (const ACSBulkDataError::AVInitErrorEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVInitErrorEx getAVInitErrorEx () { return ACSBulkDataError::AVInitErrorEx (getErrorTrace()); }
	
	template <class T >
	AVInitErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVCallbackErrorExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVCallbackError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVCallbackErrorExImpl(const AVCallbackErrorExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVCallbackErrorExImpl&>(ex).getErrorTrace()) {}
		
	AVCallbackErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVCallbackErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVCallbackErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVCallbackErrorExImpl (const ACSBulkDataError::AVCallbackErrorEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVCallbackErrorEx getAVCallbackErrorEx () { return ACSBulkDataError::AVCallbackErrorEx (getErrorTrace()); }
	
	template <class T >
	AVCallbackErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVProtocolErrorExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVProtocolError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVProtocolErrorExImpl(const AVProtocolErrorExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVProtocolErrorExImpl&>(ex).getErrorTrace()) {}
		
	AVProtocolErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVProtocolErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVProtocolErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVProtocolErrorExImpl (const ACSBulkDataError::AVProtocolErrorEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVProtocolErrorEx getAVProtocolErrorEx () { return ACSBulkDataError::AVProtocolErrorEx (getErrorTrace()); }
	
	template <class T >
	AVProtocolErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVInvalidFlowNumberExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVInvalidFlowNumber;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVInvalidFlowNumberExImpl(const AVInvalidFlowNumberExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVInvalidFlowNumberExImpl&>(ex).getErrorTrace()) {}
		
	AVInvalidFlowNumberExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVInvalidFlowNumberExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVInvalidFlowNumberExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVInvalidFlowNumberExImpl (const ACSBulkDataError::AVInvalidFlowNumberEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVInvalidFlowNumberEx getAVInvalidFlowNumberEx () { return ACSBulkDataError::AVInvalidFlowNumberEx (getErrorTrace()); }
	
	template <class T >
	AVInvalidFlowNumberExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVConnectErrorExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVConnectError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVConnectErrorExImpl(const AVConnectErrorExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVConnectErrorExImpl&>(ex).getErrorTrace()) {}
		
	AVConnectErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVConnectErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVConnectErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVConnectErrorExImpl (const ACSBulkDataError::AVConnectErrorEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVConnectErrorEx getAVConnectErrorEx () { return ACSBulkDataError::AVConnectErrorEx (getErrorTrace()); }
	
	template <class T >
	AVConnectErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVDisconnectErrorExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVDisconnectError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVDisconnectErrorExImpl(const AVDisconnectErrorExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVDisconnectErrorExImpl&>(ex).getErrorTrace()) {}
		
	AVDisconnectErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVDisconnectErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVDisconnectErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVDisconnectErrorExImpl (const ACSBulkDataError::AVDisconnectErrorEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVDisconnectErrorEx getAVDisconnectErrorEx () { return ACSBulkDataError::AVDisconnectErrorEx (getErrorTrace()); }
	
	template <class T >
	AVDisconnectErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVStartSendErrorExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVStartSendError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVStartSendErrorExImpl(const AVStartSendErrorExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVStartSendErrorExImpl&>(ex).getErrorTrace()) {}
		
	AVStartSendErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVStartSendErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVStartSendErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVStartSendErrorExImpl (const ACSBulkDataError::AVStartSendErrorEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVStartSendErrorEx getAVStartSendErrorEx () { return ACSBulkDataError::AVStartSendErrorEx (getErrorTrace()); }
	
	template <class T >
	AVStartSendErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVPaceDataErrorExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVPaceDataError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVPaceDataErrorExImpl(const AVPaceDataErrorExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVPaceDataErrorExImpl&>(ex).getErrorTrace()) {}
		
	AVPaceDataErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVPaceDataErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVPaceDataErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVPaceDataErrorExImpl (const ACSBulkDataError::AVPaceDataErrorEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVPaceDataErrorEx getAVPaceDataErrorEx () { return ACSBulkDataError::AVPaceDataErrorEx (getErrorTrace()); }
	
	template <class T >
	AVPaceDataErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVStopSendErrorExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVStopSendError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVStopSendErrorExImpl(const AVStopSendErrorExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVStopSendErrorExImpl&>(ex).getErrorTrace()) {}
		
	AVStopSendErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVStopSendErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVStopSendErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVStopSendErrorExImpl (const ACSBulkDataError::AVStopSendErrorEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVStopSendErrorEx getAVStopSendErrorEx () { return ACSBulkDataError::AVStopSendErrorEx (getErrorTrace()); }
	
	template <class T >
	AVStopSendErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVOpenReceiverErrorExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVOpenReceiverError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVOpenReceiverErrorExImpl(const AVOpenReceiverErrorExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVOpenReceiverErrorExImpl&>(ex).getErrorTrace()) {}
		
	AVOpenReceiverErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVOpenReceiverErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVOpenReceiverErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVOpenReceiverErrorExImpl (const ACSBulkDataError::AVOpenReceiverErrorEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVOpenReceiverErrorEx getAVOpenReceiverErrorEx () { return ACSBulkDataError::AVOpenReceiverErrorEx (getErrorTrace()); }
	
	template <class T >
	AVOpenReceiverErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVReceiverConfigErrorExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVReceiverConfigError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVReceiverConfigErrorExImpl(const AVReceiverConfigErrorExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVReceiverConfigErrorExImpl&>(ex).getErrorTrace()) {}
		
	AVReceiverConfigErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVReceiverConfigErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVReceiverConfigErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVReceiverConfigErrorExImpl (const ACSBulkDataError::AVReceiverConfigErrorEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVReceiverConfigErrorEx getAVReceiverConfigErrorEx () { return ACSBulkDataError::AVReceiverConfigErrorEx (getErrorTrace()); }
	
	template <class T >
	AVReceiverConfigErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVCloseReceiverErrorExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVCloseReceiverError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVCloseReceiverErrorExImpl(const AVCloseReceiverErrorExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVCloseReceiverErrorExImpl&>(ex).getErrorTrace()) {}
		
	AVCloseReceiverErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVCloseReceiverErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVCloseReceiverErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVCloseReceiverErrorExImpl (const ACSBulkDataError::AVCloseReceiverErrorEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVCloseReceiverErrorEx getAVCloseReceiverErrorEx () { return ACSBulkDataError::AVCloseReceiverErrorEx (getErrorTrace()); }
	
	template <class T >
	AVCloseReceiverErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVCbFlowTimeoutExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVCbFlowTimeout;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVCbFlowTimeoutExImpl(const AVCbFlowTimeoutExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVCbFlowTimeoutExImpl&>(ex).getErrorTrace()) {}
		
	AVCbFlowTimeoutExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVCbFlowTimeoutExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVCbFlowTimeoutExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVCbFlowTimeoutExImpl (const ACSBulkDataError::AVCbFlowTimeoutEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVCbFlowTimeoutEx getAVCbFlowTimeoutEx () { return ACSBulkDataError::AVCbFlowTimeoutEx (getErrorTrace()); }
	
	template <class T >
	AVCbFlowTimeoutExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVSetReceiverNameErrorExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVSetReceiverNameError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVSetReceiverNameErrorExImpl(const AVSetReceiverNameErrorExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVSetReceiverNameErrorExImpl&>(ex).getErrorTrace()) {}
		
	AVSetReceiverNameErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVSetReceiverNameErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVSetReceiverNameErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVSetReceiverNameErrorExImpl (const ACSBulkDataError::AVSetReceiverNameErrorEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVSetReceiverNameErrorEx getAVSetReceiverNameErrorEx () { return ACSBulkDataError::AVSetReceiverNameErrorEx (getErrorTrace()); }
	
	template <class T >
	AVSetReceiverNameErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVSetReceiverErrorExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVSetReceiverError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVSetReceiverErrorExImpl(const AVSetReceiverErrorExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVSetReceiverErrorExImpl&>(ex).getErrorTrace()) {}
		
	AVSetReceiverErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVSetReceiverErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVSetReceiverErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVSetReceiverErrorExImpl (const ACSBulkDataError::AVSetReceiverErrorEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVSetReceiverErrorEx getAVSetReceiverErrorEx () { return ACSBulkDataError::AVSetReceiverErrorEx (getErrorTrace()); }
	
	template <class T >
	AVSetReceiverErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVNotificationMechanismErrorExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVNotificationMechanismError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVNotificationMechanismErrorExImpl(const AVNotificationMechanismErrorExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVNotificationMechanismErrorExImpl&>(ex).getErrorTrace()) {}
		
	AVNotificationMechanismErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVNotificationMechanismErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVNotificationMechanismErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVNotificationMechanismErrorExImpl (const ACSBulkDataError::AVNotificationMechanismErrorEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVNotificationMechanismErrorEx getAVNotificationMechanismErrorEx () { return ACSBulkDataError::AVNotificationMechanismErrorEx (getErrorTrace()); }
	
	template <class T >
	AVNotificationMechanismErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVFlowNumbersNotMatchingErrorExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVFlowNumbersNotMatchingError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVFlowNumbersNotMatchingErrorExImpl(const AVFlowNumbersNotMatchingErrorExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVFlowNumbersNotMatchingErrorExImpl&>(ex).getErrorTrace()) {}
		
	AVFlowNumbersNotMatchingErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVFlowNumbersNotMatchingErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVFlowNumbersNotMatchingErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVFlowNumbersNotMatchingErrorExImpl (const ACSBulkDataError::AVFlowNumbersNotMatchingErrorEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVFlowNumbersNotMatchingErrorEx getAVFlowNumbersNotMatchingErrorEx () { return ACSBulkDataError::AVFlowNumbersNotMatchingErrorEx (getErrorTrace()); }
	
	template <class T >
	AVFlowNumbersNotMatchingErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AVCDBTimeoutErrorExImpl: public ACSBulkDataErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSBulkDataError;
	static const ACSErr::ErrorCode m_code = AVCDBTimeoutError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AVCDBTimeoutErrorExImpl(const AVCDBTimeoutErrorExImpl& ex) :
			ACSBulkDataErrorExImpl(const_cast<AVCDBTimeoutErrorExImpl&>(ex).getErrorTrace()) {}
		
	AVCDBTimeoutErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AVCDBTimeoutErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVCDBTimeoutErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AVCDBTimeoutErrorExImpl (const ACSBulkDataError::AVCDBTimeoutErrorEx & ex) : 
			ACSBulkDataErrorExImpl(ex.errorTrace) {}
			
	ACSBulkDataError::AVCDBTimeoutErrorEx getAVCDBTimeoutErrorEx () { return ACSBulkDataError::AVCDBTimeoutErrorEx (getErrorTrace()); }
	
	template <class T >
	AVCDBTimeoutErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSBulkDataErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

}

#endif
