/*
 * 	  Created on 15-Apr-2005
 * 
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 */
package alma.archive.wrappers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.logging.Logger;
import alma.ngas.client.JClient;
import alma.ngas.client.Status;

import alma.ngas.client.JClient;
import alma.ngas.client.Status;


import alma.archive.database.helpers.DBConfiguration;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.access.PermissionDeniedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.EntityDoesNotExistException;
import alma.archive.exceptions.syntax.IllegalHistoryNumberException;
import alma.archive.exceptions.syntax.MalformedURIException;
import alma.archive.exceptions.user.UserDoesNotExistException;

/**
 * @author simon
 */
public class DocumentFinder
{
	private InternalIF xmlstore = null;
	private JClient ngasJClient = null;
	private ArrayList ngasTypes = null;
	
	boolean storeInNgast = false;
	private String testDirectory = "";
	/**
	 * @throws DatabaseException
	 * 
	 */
	public DocumentFinder(
			InternalIF xmlstore, 
			JClient ngasJClient, 
			Logger logger,
			boolean storeInNgast,
			String testDirectory) 
	{
		this.xmlstore = xmlstore;
		this.ngasJClient = ngasJClient;
		this.ngasTypes = new ArrayList();
		this.storeInNgast = storeInNgast;
		this.testDirectory = testDirectory;
	}
	
	public void addNgasType(String schemaName)
	{
		ngasTypes.add(schemaName);
	}
	
	public InputStream fetch(URI uid) 
		throws 
			PermissionDeniedException, 
			EntityDoesNotExistException, 
			DatabaseException, 
			UserDoesNotExistException, 
			IllegalHistoryNumberException, 
			MalformedURIException, 
			ModuleCriticalException, 
			ArchiveException
	{
		DocumentData dd = xmlstore.status(uid,"archiveClient");
		URI schemaUri = dd.getSchema();
		SchemaManager smanager = xmlstore.getSchemaManager("archiveClient");
		String schemaName = smanager.getSchemaName(schemaUri);
		if (ngasTypes.contains(schemaName)){
			if (storeInNgast){	
				Logger logger = Logger.global;
				String filename = uid.toASCIIString().substring(6);
				
				Status status = ngasJClient.retrieve(
					filename,uid2filename(uid.toASCIIString().substring(6)));
				
				if (status.getOK()) {
					logger.info(status.getRequestStatus());
					logger.fine(status.getMessage());
					
					try{
						FileInputStream fis = new FileInputStream(
							uid2filename(uid.toASCIIString().substring(6)));
						return new BufferedInputStream(fis);
					}
					catch (FileNotFoundException e){
						throw new DatabaseException(e);
					}
				}
				else throw new DatabaseException(status.getMessage());
			}
			else{
				try{
					FileInputStream fis = new FileInputStream(
					uid2filename(uid.toASCIIString().substring(6)));
					return new BufferedInputStream(fis);
				}
				catch (FileNotFoundException e){
					throw new DatabaseException(e);
				}
			}
		}
		else{
			return new StringBufferInputStream(
				xmlstore.get(uid,"archiveClient"));
		}
	}
	
	protected String uid2filename(String uid) {
		if (testDirectory.equalsIgnoreCase("")){
			return uid.replace('/', '_');
		}
		else{
			return testDirectory + "/" + uid.replace('/', '_');
		}
		
	}
}
