/*
 * 	  Created on 16-Sep-2004
 * 
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 */
package alma.archive.database.vdoc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.jdom.Element;

/**
 * @author simon
 */
public class Item
{
	private HashMap map = null;
	private String type = "";
	
	public Item(String type)
	{
		map = new HashMap();
		this.type = type;
	}
	
	public Item(Element item)
	{
		map = new HashMap();
		this.type = item.getAttributeValue("type");
		List children = item.getChildren();
		Iterator iter = children.iterator();
		while (iter.hasNext())
		{
			Element e = (Element)iter.next();
			String name = e.getName();
			String value = e.getText();
			map.put(name,value);
		}
	}
	
	public void setProperty(String name, String value)
	{
		map.put(name,value);
	}
	
	public String getProperty(String name)
	{
		return (String)map.get(name);
	}
	
	public boolean containsProperty(String name)
	{
		return map.containsKey(name);
	}
	
	public Element getItemElement()
	{
		Element item = new Element("item");
		item.setAttribute("type",type);
		Set set = map.keySet();
		Iterator iter = set.iterator();
		while (iter.hasNext())
		{
			String name = (String)iter.next();
			Element e = new Element(name);
			e.addContent((String)map.get(name));
			item.addContent(e);
		}
		return item;
	}
}
