/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 *    Created on Nov 20, 2003
 *
 */
 
  
// $Author: hmeuss $
// $Date: 2004/04/05 13:59:29 $
// $Log: UserManagerImpl.java,v $
// Revision 1.1  2004/04/05 13:59:29  hmeuss
// Internal IF implementation adapted to Oracle
//
// Revision 1.3  2004/01/23 15:11:45  hmeuss
// Added permission check in DB2CursorImpl
//
// Revision 1.2  2004/01/19 16:29:46  hmeuss
// Splitted functionality of Db2Database into Db2DatabaseReader, Db2DatabaseWriter, Db2DatabaseCache
//
// Revision 1.1  2003/11/20 13:03:41  hmeuss
// Implemented new internal IF
// 
 
package alma.archive.database.oracle;

import alma.archive.database.interfaces.UserManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.user.RoleAlreadyExistsException;
import alma.archive.exceptions.user.RoleDoesNotExistException;
import alma.archive.exceptions.user.RoleNotAssignedException;
import alma.archive.exceptions.user.UserAlreadyExistsException;
import alma.archive.exceptions.user.UserDoesNotExistException;

/**
 * @author hmeuss
 *
 */
public class UserManagerImpl implements UserManager {

// TODO check permissions

DatabaseWriter databaseWriter;
String userName;

	/**
	 * 
	 */
	public UserManagerImpl(String user) throws DatabaseException {
		super();
		databaseWriter = DatabaseWriter.instance();
		userName=user;
	}

	/**
	 * @see alma.archive.database.interfaces.UserManager#close()
	 */
	public void close() throws DatabaseException {

	}

	/**
	 * @see alma.archive.database.interfaces.UserManager#addUser(java.lang.String)
	 */
	public void addUser(String user)
		throws DatabaseException, ArchiveException, UserAlreadyExistsException {
			// TODO check permissionsS
databaseWriter.addUser(user);
	}

	/**
	 * @see alma.archive.database.interfaces.UserManager#deleteUser(java.lang.String)
	 */
	public void deleteUser(String user)
		throws DatabaseException, ArchiveException, UserDoesNotExistException {
			// TODO check permissionsS
databaseWriter.deleteUser(user);
	}

	/**
	 * @see alma.archive.database.interfaces.UserManager#addRole(java.lang.String)
	 */
	public void addRole(String role)
		throws DatabaseException, ArchiveException, RoleAlreadyExistsException {
			// TODO check permissionsS
			databaseWriter.addRole(role);
	}

	/**
	 * @see alma.archive.database.interfaces.UserManager#deleteRole(java.lang.String)
	 */
	public void deleteRole(String role)
		throws DatabaseException, ArchiveException, RoleDoesNotExistException {
			// TODO check permissionsS
databaseWriter.deleteRole(role);
	}

	/**
	 * @see alma.archive.database.interfaces.UserManager#assignRole(java.lang.String, java.lang.String)
	 */
	public void assignRole(String user, String role)
		throws
			DatabaseException,
			ArchiveException,
			RoleDoesNotExistException,
			UserDoesNotExistException {
				// TODO check permissionsS
databaseWriter.assignRole(user,role);
	}

	/**
	 * @see alma.archive.database.interfaces.UserManager#withdrawRole(java.lang.String, java.lang.String)
	 */
	public void withdrawRole(String user, String role)
		throws
			DatabaseException,
			ArchiveException,
			RoleDoesNotExistException,
			UserDoesNotExistException,
			RoleNotAssignedException {
				// TODO check permissionsS
databaseWriter.withdrawRole(user,role);
	}

}
