/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 *    Created on Jul 3, 2003
 *
 */

// $Author: hmeuss $
// $Date: 2009/07/17 14:36:51 $
//
// $Log: DBConfig.java,v $
// Revision 1.16  2009/07/17 14:36:51  hmeuss
// removed restore functionality including references to xml_meta_history
//
// Revision 1.15  2009/02/16 16:42:42  hmeuss
// Added environment in order to store STE information in log tables.
//
// Revision 1.14  2007/10/24 15:06:21  hmeuss
// Added retrieval methods for logs and some more infrastructure
//
// Revision 1.13  2007/10/24 09:56:42  hmeuss
// changed to new relational storage
//
// Revision 1.12  2007/07/05 13:27:01  hmeuss
// Changed ID storage in Oracle: Now sequences are used
//
// Revision 1.11  2006/04/21 14:32:28  hmeuss
// New version, with test for new UIDLibrary
//
// Revision 1.10  2006/03/28 12:57:26  hmeuss
// removed unused variables
//
// Revision 1.9  2006/01/04 10:32:40  hmeuss
// Preparing new UID scheme: added variable for archiveID
//
// Revision 1.8  2005/05/27 12:21:07  hmeuss
// Oracle table names not longer than 30 characters
//
// Revision 1.7  2005/05/27 11:43:20  hmeuss
// table names in Oracle can have maximally 30 characters
//
// Revision 1.6  2004/10/04 14:14:32  hmeuss
// *** empty log message ***
//
// Revision 1.5  2004/10/01 08:06:51  hmeuss
// Changed initialization of IdentifierArchive
//
// Revision 1.4  2004/07/20 14:46:58  hmeuss
// corrected some errors
//
// Revision 1.3  2004/06/01 15:53:12  hmeuss
// Added treatment of virtual documents
//
// Revision 1.2  2004/05/05 08:45:55  hmeuss
// *** empty log message ***
//
// Revision 1.1  2004/04/05 13:59:29  hmeuss
// Internal IF implementation adapted to Oracle
//
// Revision 1.9  2004/03/18 09:49:33  hmeuss
// changed configuration to work with testStart, testEnd
//
// Revision 1.8  2004/02/17 14:37:32  hmeuss
// Added some schema treatment
//
// Revision 1.7  2004/02/11 16:20:09  hmeuss
// *** empty log message ***
//
// Revision 1.6  2003/12/18 13:20:05  hmeuss
// *** empty log message ***
//
// Revision 1.5  2003/11/20 12:47:31  hmeuss
// *** empty log message ***
//
// Revision 1.4  2003/10/30 08:36:26  hmeuss
// *** empty log message ***
//
// Revision 1.3  2003/07/24 15:12:14  hmeuss
// Beginning the implementation for real DB2, version 8 functionality
//
// Revision 1.2  2003/07/14 12:24:33  hmeuss
// First DB2 implementation
//
// Revision 1.1  2003/07/03 09:50:27  hmeuss
// Class for storing DB2 configurations like table names etc
// 

package alma.archive.database.oracle;

import alma.archive.wrappers.Permissions;

/**
 * @author hmeuss
 * 
 * Stores configuration information for the database in public static variables.
 * 
 * 
 * SHORT DESCRIPTION OF ASSUMED TABLE STRUCTURE IN Oracle:
 * all tables in the xmlstore are prefixed with "xml_"!
 * 
 * If columns in two tables have the same name they take the same argument structure (eg UID)
 * 
 * There are two kinds of tables: schema independent and dependent.
 * 
 * schema independent tables:
 * 
 * TABLE metaInfo (tableName_metaInfo)
 *  Name  |  Value
 * -------+--------
 * String | String
 * 
 * For storing metainformation in parameters. List of parameter names:
 * lastUID: The last UID that has been given away
 * 
 * SQL to create metaInfo table
 * CREATE TABLE metaInfo (name VARCHAR(32), value VARCHAR(128))
 * 
 * 
 * TABLE schema_entities (tableName_schemas)
 * UID    | SchemaName | Version  | Timestamp |     xml        | dadContents | schemaUID | owner  | deleted | readPermissions | writePermissions | hidden  | dirty   | virtual 
 * -------+------------+----------+-----------+----------------+-------------+-----------+--------+---------+-----------------+------------------+---------+--------------------
 * string | string     | smallint | timestamp |   xmltype      |   string    | string    | string | boolean | string ??       | string ??        | boolean | boolean | boolean
 * 
 * indexed on first three columns
 * 
 * The schema_entities table has the same columns as the other entities tables, apart from the fact that it contains the version attribute and the schema name
 * 
 * Line to create schema table
 *  create table xml_schema_entities (archive_uid VARCHAR(33) NOT NULL, schemaName VARCHAR(32) NOT NULL, Version number(16) NOT NULL, timestamp timestamp not null, xml xmltype, schemaUID VARCHAR(33), owner VARCHAR(128), deleted NUMBER(1), readPermissions VARCHAR(128), writePermissions VARCHAR(128), hidden number(1), dirty number(1))
 *
 * Note that the column named schemaContents above is called xml in the database. Also, the table is called schema_entities.
 *  
 * 
 * TABLE xml_history (tableName_xml_history)
 * UID    | timestamp | xml    | schemaName
 * -------+-----------+--------+------------
 * string | timestamp | clob   |  string
 * 
 * indexed on UID, timestamp 
 * contains also the head of history
 * No index on xml column
 * 
 * Line to create xml_history table
 * create table xml_history (uid varchar(33) not null, timestamp timestamp not null, xml clob not logged, schemaName varchar(32), primary key (uid, timestamp))
 * create unique index xml_hist_ind on xml_history(uid, timestamp) 
 * 
 * 
 * NOTE meta_history does not exist anymore, since restore functionality is not needed on SW basis
 * TABLE meta_history ("execblock"+tableNameSuffix_meta_history)
 * UID    | timestamp | metaColumn | newValue
 * -------+-----------+------------+----------
 * string | timestamp | smallInt   | string
 * 
 * indexed on UID, timestamp
 * metaColumn holds the name of the changed metadata, newValue the new value.
 * 
 * There are Java variables defined mapping the smallint of metacolumn to the real meaning. These variables are called metaHist_... 
 *   
 * Line to create meta_history table:
 * create table meta_history (uid varchar(33) not null, timestamp timestamp not null, metaColumn smallint not null, newValue varchar(64), primary key (uid, timestamp, metaColumn))
 * create index meta_hist_ind on meta_history(uid, timestamp)
 * 
 * TABLE userRoles (tableName_userRoles)
 * userName | roleName
 * ---------+----------
 * string   | string
 * 
 * Indexed on userName
 * Line to create userRoles table:
 * create table userRoles (userName varchar(64) not null, roleName varchar(64) not null)
 * create unique index userroles_ind on userRoles(username)
 * 
 * 
 * TABLE users (tableName_users)
 * userName 
 * ---------
 * string  
 * 
 * Line to create users table:
 * create table users (userName varchar(64) not null)
 * 
 * 
 * TABLE roles (tableName_roles)
 * roleName
 * ---------
 * string  
 * 
 * Indexed on roleName
 * Line to create roles table:
 * create table roles (roleName varchar(64) not null)
 *
 *
 * TABLE schemaNamespaces (tableName_schemaNamespaces)
 * schemaUID | prefix 
 *  ---------+--------
 *  string   | string 
 * 
 * indexed on schemaUID
 * create table xml_schemaNamespaces(schemaUID varchar(33), prefix varchar(16));
 * 
 *
 * TABLE namespaces (tableName_namespaces)
 *   prefix | namespace
 * namespace
 *  --------+-----------
 *   string | string
 * 
 * indexed on prefix
 * create table xml_namespaces(prefix varchar(16) PRIMARY KEY, namespace varchar(128));
 *
 *  
 * For each schema a set of tables: (example schema name "ExecBlock")
 * 
 * TABLE execblock_entities ("execblock"+tableNameSuffix_entities)
 * UID    | timestamp |   xml   | schemaUID | owner  | deleted | readPermissions | writePermissions | hidden  | dirty   | virtual 
 * -------+-----------+---------+-----------+--------+---------+-----------------+------------------+---------+-------------------
 * string | timestamp | xmltype | string    | string | boolean | string ??       | string ??        | boolean | boolean | boolean
 * 
 * indexed on UID
 * XML column is enabled with XML Extender
 * the columns timestamp and xml correspond to the head of history
 * 
 * 
 * TODO Think about dividing the above table into the xml part (uid, timestamp, xml) and a metadata part. Metadata could be stored for all schemas together in one table, thus saving for some queries the overhead of finding out the schema name for a uid in order to access metadata for the uid. 
 * 
 * TODO think of alternatives: Split entities table into head table and version-independent entities table. 
 * 
 * 
 * 
 * NAMING CONVENTIONS:
 * 
 * This file mainly stores names of tables and columns in Java string variables. 
 * The Java variables for table names are given in the tables descriptions above (in brackets, behind table name)
 * The Java variables for column names are exactly as in the columns described above, but in lower case, with the prefix "colName_", eg.: colName_uid
 * The convention for column names holds for *all* tables.
 * 
 */


public class DBConfig {

	/* Server */
//	protected static String serverName = "arclux2.hq.eso.org";
	protected static final String serverName = "almadev1.hq.eso.org";
//
//	/* Driver */
//	protected static String type2driver = "COM.ibm.db2.jdbc.app.DB2Driver";   // driver name  (app-driver!)
//	protected static String type3driver = "COM.ibm.db2.jdbc.net.DB2Driver";   // driver name (net driver) 
//	protected static String type4driver = "com.ibm.db2.jcc.DB2Driver";        // driver name  (type 4 driver!)
//
//    /* URL */ 
//	protected static String type2url = "jdbc:db2:";  							// URL of database (app)
//	protected static String type34url = "jdbc:db2://";  // URL of database (net + type 4)
//	
//	/* Port */
//	protected static int type3port = 6789;
//	protected static int type4port = 50000;      
//
//	/* User */
//	// almadev1:
//	protected static String user = "db2inst1"; // user name for read/write
//	protected static String password = "db$inst"; //password for read/write
//	// arclux2:
//	// protected static String user = "db2inst8"; // user name for read/write
//	// protected static String password = "db$inst8"; //password for read/write

	/* Database name*/
	protected static final String dbName_xmlStore = "xmlStore";
	
	/* tablespace */
	protected static final String tablespace="USERSPACE1";

	/* table name suffixes for schema specific tables */
	protected static final String tableNameSuffix_entities = "_entities";
	protected static final String tableNameSuffix_side_unique = "_side_unique";
	protected static final String tableNameSuffix_side = "_side_";
	
/* table names for general tables */
protected static final String tableName_schemas = "xml_schema"+tableNameSuffix_entities;
//protected static final String tableName_schemas = "foo_schema"+tableNameSuffix_entities;
protected static final String tableName_xml_history = "xml_history";
//protected static final String tableName_meta_history = "xml_meta_history";
protected static final String tableName_metaInf = "xml_metaInfo";
protected static final String tableName_users = "xml_users";
protected static final String tableName_roles = "xml_roles";
protected static final String tableName_userRoles = "xml_userRoles";
protected static final String tableName_schemaNamespaces = "xml_schemaNamespaces";
protected static final String tableName_namespaces = "xml_namespaces";

protected static final String tableName_logging = "xml_logEntries";

protected static final String tabPrefix = "xml_";

/* column names for all tables */
protected static final String colName_uid = "archive_uid";
protected static final String colName_schemaName = "schemaName";
protected static final String colName_schemaContents = "xml";
protected static final String colName_timestamp = "timestamp";
protected static final String colName_xml = "xml";
protected static final String colName_schemaUid = "schemaUID";
protected static final String colName_owner = "owner";
protected static final String colName_deleted = "deleted";
protected static final String colName_readPermissions = "readPermissions";
protected static final String colName_writePermissions = "writePermissions";
protected static final String colName_hidden = "hidden";
protected static final String colName_dirty = "dirty";
//protected static final String colName_metaColumn = "metaColumn";
//protected static final String colName_newValue = "newValue";
protected static final String colName_paramName = "name";
protected static final String colName_paramValue = "value";
protected static final String colName_roleName = "roleName";
protected static final String colName_userName = "userName";
protected static final String colName_prefix = "prefix";
protected static final String colName_namespace = "namespace";
protected static final String colName_virtual = "virtual";
protected static final String colName_version = "version";  // only used in schemas

/* columns for the logging table: */
protected static final String colName_log_level = "Log_Level";
protected static final String colName_log_message = "Message";
protected static final String colName_log_TimeStamp = "LogTimeStamp";
protected static final String colName_log_File = "Filename";
protected static final String colName_log_Line = "Line";
protected static final String colName_log_Routine = "Routine";
protected static final String colName_log_SourceObject = "SourceObject";
protected static final String colName_log_Host = "Host";
protected static final String colName_log_Process = "Process";
protected static final String colName_log_Context = "Context";
protected static final String colName_log_Thread = "Thread";
protected static final String colName_log_LogId = "LogId";
protected static final String colName_log_Priority = "Priority";
protected static final String colName_log_Uri = "Uri";
protected static final String colName_log_Audience = "Audience";
protected static final String colName_log_Array = "Alma_Array";
protected static final String colName_log_Antenna = "Antenna";
protected static final String colName_log_dataStrings = "dataStrings";
protected static final String colName_log_xml = "xml";
protected static final String colName_log_ste = "steEnv";

/* (virtual) name for the schema of schemas */ 
protected static final String schemaSchemaName = "schema";
/* (virtual) name for the schema of schemas */ 
protected static final String schemaSchemaUri = "http://www.w3.org/XML/Schema";
/* (virtual) name for the schema of schemas */ 
protected static final String schemaOwner = "ADMIN";


/* Flag names  
 * flags are columns in the entities tables. To provide a more generic access there is a method in the internal IF,
 * that allows to set values for arbitrary flags (defined by a string parameter).
 * The corresponding column names are defined here:
 * 
 */
protected static final String flagNameDirty=colName_dirty;
protected static final String flagNameHidden=colName_hidden;
protected static final String flagNameDeleted=colName_deleted;

/* 
 * values for columnNames in meta_history table:
 */ 
 //protected static final short metaHist_schemaUID = 1;
 //protected static final short metaHist_owner = 2;
 //protected static final short metaHist_deletedHiddenDirty = 3;   // define encoding!!!
 //protected static final short metaHist_permissions = 4;  // TODO all permissions in one or divided???
 
// protected static final short metaHist_lastUID = 11;  // for the netry lastUID in the XML_metainfo table
 
// TODO implement history for user manager?

/* 
 * parameter names for metaInf table
 */
 /* The last UID stored, changed everytime a new UID is fetched. Actually, only the middle part of an UID is 
  * stored as long value.
  */
 public static final String paramName_lastUIDstored = "uid_seq";
 public static final String colName_nextVal = "nextval";
 
// public static final String paramName_lastUID = "lastUID";
 
 /*
  * The ID of the Archive. Since there might be many instances of archives (with database systems in the 
  * background), each archive has its own ID.
  */
 public static final String paramName_archiveID = "archiveID";



/*
 * construct table name for the _entities tables
 * 
 */
public static String schemaTabName(String schemaName) {
	// maximal length of Oracle table names is 30 characters
	return tabPrefix+schemaName.substring(0,(schemaName.length()>17) ? 17 : schemaName.length())+tableNameSuffix_entities;
}

/*
 * construct index name for the _entities tables
 * 
 */
public static String schemaIndName(String schemaName) {
	// maximal length of Oracle table names is 30 characters
	return tabPrefix+schemaName.substring(0,(schemaName.length()>17) ? 17 : schemaName.length())+"index";
}


	/**
	 * @param dataType
	 * @return true, iff dataType is a character type (i.e. literals have to be enclosed in 
	 * apostrophs in SQL)
	 */
	public static boolean isCharType(String dataType) {
		// TODO implement correct test
		// In the moment: Every datatype beginning with "varchar" is a charType 
		return dataType.length() > 6
			? dataType.substring(0, 7).equalsIgnoreCase("varchar")
			: false;
	}
	

	/**
	 * encode permissions as a string to be stored in metaHistory table. 
	 * @param permissions
	 * @return
	 */
	//protected static String metaHist_permEncoding(Permissions permissions) {
		// TODO find better encoding?
//		return "R:"+permissions.getRead()+"---W:"+permissions.getWrite();
	//}
	/**
	 * decode permissions string to be stored in metaHistory table. 
	 * @param permissions string
	 * @return
	 */
	/*
	protected static Permissions metaHist_permEncoding2Perm(String permString) {
		// TODO not tested
		String read, write;
		int delimPos = permString.indexOf("---W:");
		read = permString.substring(2, delimPos);
		write = permString.substring(delimPos+5,permString.length());
		return new Permissions(read, write);
	}
*/
	/**
	 * encode the three parameters as a string to be stored in metaHistory table.
	 * All three parameters encode boolean values.  
	 * @param deleted
	 * @param hidden
	 * @param dirty
	 * @return
	 */
	/*
	protected static String metaHist_DHDEncoding(int deleted, int hidden, int dirty) {
*/		/* 
		 * deleted: bit 0
		 * hidden:  bit 1
		 * dirty:   bit 2
		 */
		 // TODO better encoding?
	/*	 int out = deleted+2*hidden+4*dirty;
		
		return String.valueOf(out);
	}
	*/
	/**
	 * decode the three parameters as stored in metaHistory table.
	 * All three parameters encode boolean values.  
	 * @param deleted
	 * @param hidden
	 * @param dirty
	 * @return
	 *//*
	protected static int metaHist_DHDEncoding2DelBool(int DHDcode) {*/
		/* 
		 * deleted: bit 0
		 * hidden:  bit 1
		 * dirty:   bit 2
		 *//*
		 return (DHDcode % 2);
	}
	*/
	/*
	protected static int metaHist_DHDEncoding2HidBool(int DHDcode) {
	*/
		/* 
		 * deleted: bit 0
		 * hidden:  bit 1
		 * dirty:   bit 2
		 */
	/*
		 return (DHDcode>>1) % 2;
	}
	*/
	/*
	protected static int metaHist_DHDEncoding2DirBool(int DHDcode) {
	*/
		/* 
		 * deleted: bit 0
		 * hidden:  bit 1
		 * dirty:   bit 2
		 */
	/*
		 return (DHDcode>>2) % 2;
	}
	*/
}
