/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 *    Created on Aug 27, 2003
 *
 */

// $Author: hmeuss $
// $Date: 2004/09/17 08:50:38 $
// $Log: UserManager.java,v $
// Revision 1.3  2004/09/17 08:50:38  hmeuss
// Added ModuleCriticalException that will be propagated upwards through all classes
//
// Revision 1.2  2003/09/25 13:54:12  sfarrow
// *** empty log message ***
//
// Revision 1.1  2003/09/03 14:30:22  hmeuss
// *** empty log message ***
//
// Revision 1.2  2003/08/29 09:02:04  hmeuss
// Java internal interface updated
//
// Revision 1.1  2003/08/28 15:42:11  hmeuss
// A first proposal for the new Java internal interface
// 

package alma.archive.database.interfaces;

import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.user.RoleAlreadyExistsException;
import alma.archive.exceptions.user.RoleDoesNotExistException;
import alma.archive.exceptions.user.RoleNotAssignedException;
import alma.archive.exceptions.user.UserAlreadyExistsException;
import alma.archive.exceptions.user.UserDoesNotExistException;

/**
 * @author hmeuss
 *
 */
public interface UserManager {

	void close() throws DatabaseException;
	// UserManager has no permissions. Everybody having a reference to it may do whatever!

	void addUser(String user)
		throws
			ModuleCriticalException,
			DatabaseException,
			ArchiveException,
			UserAlreadyExistsException;
	void deleteUser(String user)
		throws
			ModuleCriticalException,
			DatabaseException,
			ArchiveException,
			UserDoesNotExistException;

	void addRole(String role)
		throws
			ModuleCriticalException,
			DatabaseException,
			ArchiveException,
			RoleAlreadyExistsException;
	void deleteRole(String role)
		throws
			ModuleCriticalException,
			DatabaseException,
			ArchiveException,
			RoleDoesNotExistException;

	void assignRole(String user, String role)
		throws
			ModuleCriticalException,
			DatabaseException,
			ArchiveException,
			RoleDoesNotExistException,
			UserDoesNotExistException;
	void withdrawRole(String user, String role)
		throws
			ModuleCriticalException,
			DatabaseException,
			ArchiveException,
			RoleDoesNotExistException,
			UserDoesNotExistException,
			RoleNotAssignedException;
}
