/**
 *
 * Copyright European Southern Observatory 2008
 */

package alma.archive.database.helpers.wrappers;

import java.util.logging.Logger;

/**
 * An interface to the archiveConfig.properties file.
 * 
 * This class implements Tmcdb-specific policies.
 *
 * @author rkurowsk, May 3, 2010
 * @version $Revision: 1.1.2.2 $
 */

// $Id: TmcdbDbConfig.java,v 1.1.2.2 2010/05/03 09:36:09 rkurowsk Exp $

public class TmcdbDbConfig extends AbstractDbConfig {

	private static final String TMCDB_CONNECTION	= "archive.tmcdb.connection";
	private static final String TMCDB_USER 			= "archive.tmcdb.user";
	private static final String TMCDB_PASSWORD 		= "archive.tmcdb.passwd";
	
    /**
     * Read DB configuration properties from a file.
     * 
     * @param logger
     * @throws DbConfigException
     * @throws IllegalArgumentException
     */
    public TmcdbDbConfig(Logger logger ) throws DbConfigException {
        super( logger );
    }
    
    /**
     * Extracts the connection, user & password params
     * @throws DbConfigException
     */
    @Override
    protected void extractParams()throws DbConfigException {
    	
    	configureConnectionUrl(extractParam(TMCDB_CONNECTION));
    	setUser(extractParam(TMCDB_USER));
        setPassword(extractParam(TMCDB_PASSWORD));
    }
    
}