/**
 * Copyright European Southern Observatory 2010
 */

package alma.archive.database.helpers.wrappers;

import java.util.logging.Logger;

/**
 * A helper class for loading archiveConfig.properties
 *
 * @author rkurowsk, May 3, 2010
 * @version $Revision: 1.1.2.2 $
 */

// $Id: RelationalDbConfig.java,v 1.1.2.2 2010/05/03 09:36:09 rkurowsk Exp $

public class RelationalDbConfig extends AbstractDbConfig {
	
    
    // Keywords in archiveConfig.properties
	private static final String ARCHIVE_RELATIONAL_CONNECTION 	= "archive.relational.connection";
	private static final String ARCHIVE_RELATIONAL_USER 		= "archive.relational.user";
	private static final String ARCHIVE_RELATIONAL_PASSWORD 	= "archive.relational.passwd";

	/** 
     * Constructor which attempts to load dbConfiguration and 
     * hence the archiveConfig.properties file. 
     * 
     * @param logger
     * @throws DbConfigException
     * @throws IllegalArgumentException
     */
    public RelationalDbConfig(Logger logger ) throws DbConfigException {
        super(logger);
    }
    
    /**
     * Extracts the connection, user & password params
     * @throws DbConfigException
     */
    @Override
    protected void extractParams()throws DbConfigException {
    	
    	configureConnectionUrl(extractParam(ARCHIVE_RELATIONAL_CONNECTION));
    	setUser(extractParam( ARCHIVE_RELATIONAL_USER));
        setPassword(extractParam(ARCHIVE_RELATIONAL_PASSWORD));
    }

}