/*
 * 	  Created on 18-Feb-2004
 * 
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 */
package alma.archive.database.helpers;

import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;

import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;

/**
 * @author simon
 * 
 * A URI Resolver that allows access to the internal interface of the archive.
 * Documents can be included in the XSLT document() call, this resolver
 * recognises the uid:// schema and fetches the document.
 */
public class ArchiveResolver implements URIResolver
{
	InternalIF internal = null;
	String user = "";
	
	public ArchiveResolver(InternalIF internal, String user)
	{
		this.internal = internal;
		this.user = user;
	}
	
	/**
	 * @see javax.xml.transform.URIResolver#
	 * resolve(java.lang.String, java.lang.String)
	 */
	public Source resolve(String href, String base) 
		throws 
			TransformerException
	{
		URI uri = null;
		try {
			uri = new URI(href);
		}
		catch (URISyntaxException e) {
			System.out.println("Invalid uri: " + e.getMessage());
			//MPA: no action, no logging. is it correct?
		}
		
		if (uri.getScheme().equalsIgnoreCase("uid"))
		{
			//Fetching something from the archive
			try
			{
				String xml = internal.get(uri,user);
				return new StreamSource(new StringReader(xml));
			}
			catch (ArchiveException e) {
				throw new TransformerException(e);
			} catch (ModuleCriticalException e) {
				throw new TransformerException(e.getCause());
			}
		}
		else if (uri.getScheme().equalsIgnoreCase("sql"))
		{
			return null;
		}
		else if (uri.getScheme().equalsIgnoreCase("ngast"))
		{
			return null;
		}
		
		return null;
	}
	
	public static void main(String[] args) 
		throws 
			TransformerException, 
			DatabaseException, 
			ModuleCriticalException
	{
		TransformerFactory tf = TransformerFactory.newInstance();
		//tf.setURIResolver(new ArchiveResolver());

		//String transfilen = args[1];
		String transfilen = "/home/simon/firstvirtual.xslt";
		//String virtualfilen = args[2];
		String virtualfilen = "/home/simon/firstvirtual.xml";
		
		Templates transTemplate = tf.newTemplates(new StreamSource(transfilen));
		Source virtualSource = new StreamSource(virtualfilen);
		
		Transformer trans = transTemplate.newTransformer();
		InternalIF internalif =
			InternalIFFactory.getInternalIF(
				Logger.getAnonymousLogger());
		trans.setURIResolver(new ArchiveResolver(internalif,"user"));
		
		StringWriter writer = new StringWriter();
		trans.transform(virtualSource,new StreamResult(writer));
		System.out.println(writer.toString());
	}
}
