/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 *    Created on Jan 12, 2005
 *
 */

// $Author: hmeuss $
// $Date: 2009/04/14 11:57:09 $
// $Log: archiveQueryClient.java,v $
// Revision 1.27  2009/04/14 11:57:09  hmeuss
// changed IF for admin.close and other Archive only methods
//
// Revision 1.26  2009/02/13 13:46:51  hmeuss
// removed NGAS connection that was not working anyhow
//
// Revision 1.25  2008/12/01 15:16:17  hmeuss
// We only contact ACS in the -c case now, otherwise not (not necessary then and was in addition printing out confusng messages).
//
// Revision 1.24  2008/01/23 16:18:19  hmeuss
// Improved handling of loggers
//
// Revision 1.23  2007/07/03 09:49:17  hmeuss
// Adapted to new names of NGAS libraries
//
// Revision 1.22  2007/01/04 15:22:49  hmeuss
// improved error messages
//
// Revision 1.21  2006/11/21 10:59:09  hmeuss
// it is now possible to use queries with blanks
//
// Revision 1.20  2006/10/10 12:48:53  hsommer
// ContainerException now called AcsJContainerServicesEx
//
// Revision 1.19  2006/09/15 14:11:46  hsommer
// new exceptions due to using the ACS-variant of Range
//
// Revision 1.18  2006/09/06 10:08:29  hsommer
// added TODO
//
// Revision 1.17  2006/07/04 13:56:44  hmeuss
// made the help work again
//
// Revision 1.16  2006/06/14 09:58:18  hmeuss
// removed bug with namespaces. Why was it again here????
//
// Revision 1.15  2006/06/01 09:41:28  hmeuss
// Fixed bug: namespaces are now correctly used in queries
//
// Revision 1.14  2006/02/16 12:40:40  mpasquat
// added comments about exception handling problems
//
// Revision 1.13  2006/02/15 18:11:15  sfarrow
// moved to get default
//
// Revision 1.12  2006/01/20 10:06:42  hmeuss
// added -w switch, to write query result into file
//
// Revision 1.11.2.1  2006/01/20 10:02:41  hmeuss
// added -w switch, to write query result into file
//
// Revision 1.11  2005/11/28 11:01:29  hmeuss
// Checks whether ACS is running and tries to inform Archive components now.
//
// Revision 1.10  2005/07/21 15:34:10  hmeuss
// archiveCleanTest calls now archiveQuery -c, which cleans the Archive. (This makes the script work on all DBs.)
// archiveQuery has new option -c (in the long run: move to another CLI)
//
// Revision 1.9  2005/06/01 13:34:30  hmeuss
// added -x option so that pure XML retrieval works again
//
// Revision 1.8  2005/05/31 09:36:14  hmeuss
// small changes to get the archiveQueryClient running for Oracle again, also trying to get ArchiveManager running for Oracle again
//
// Revision 1.7  2005/05/30 15:01:07  hmeuss
// made changes so that client is running even if not all info is in dbConfig
//
// Revision 1.6  2005/05/30 14:50:30  hmeuss
// moved the call to init() to the beginning again (otherwise won't work)
//
// Revision 1.5  2005/05/30 14:47:44  hmeuss
// return type of main is void again, otherwise it will not work from command line
//
// Revision 1.4  2005/04/28 13:15:59  sfarrow
// resturctured slightly
//
// Revision 1.3  2005/04/22 10:37:31  sfarrow
// *** empty log message ***
//
// Revision 1.2  2005/04/18 11:13:40  sfarrow
// Updated the query client to access the ngast server. Still needs to be made configurable.
//
// Revision 1.1  2005/01/13 10:45:08  hmeuss
// - Constructed command line query interface for Archive.
// - Added functionality to init() for Oracle.
// 
package alma.archive.client;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import alma.acs.logging.ClientLogManager;

import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

import alma.ArchiveIdentifierError.wrappers.AcsJArchiveIdentifierErrorEx;
import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.acs.component.client.ComponentClient;
import alma.archive.database.helpers.DBConfiguration;
import alma.archive.database.interfaces.DBCursor;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.access.EntityDirtyException;
import alma.archive.exceptions.access.PermissionDeniedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.EntityDoesNotExistException;
import alma.archive.exceptions.syntax.MalformedURIException;
import alma.archive.exceptions.user.UserDoesNotExistException;
import alma.archive.wrappers.DocumentFinder;
import alma.archive.wrappers.ResultStruct;
import alma.xmlstore.Administrative;
import alma.xmlstore.ArchiveConnection;
import alma.xmlstore.ArchiveConnectionHelper;
import alma.xmlstore.ArchiveInternalError;

/**
 * @author hmeuss
 * 
 */
public class archiveQueryClient {

	/**
	 * used for informing Archive/ACS components that something changed. Copied
	 * from ARCHIVE/Archive/SchemaLoader
	 * 
	 * @author hmeuss
	 * 
	 */
	private class AcsClient extends ComponentClient {

		// private String connName = "ARCHIVE_CONNECTION";
		private String connTypeName = "IDL:alma/xmlstore/ArchiveConnection:1.0";

		/**
		 * @param logger
		 * @param managerLoc
		 * @param clientName
		 * @throws Exception
		 * @throws Exception
		 */
		public AcsClient(Logger logger, String managerLoc, String clientName)
				throws Exception {
			super(logger, managerLoc, clientName);
		}

		/**
		 * if ACS is running, call reinit on administrative component, so that
		 * Archive components are informed that new schemas are there
		 * 
		 * TODO: this method is probably not needed (relict of happy
		 * copy'n'paste)
		 */

		public void informACScomponents() {

			// get reference to Archive Connection:
			ArchiveConnection conn = null;
			try {
				/*
				 * conn = ArchiveConnectionHelper.narrow(getContainerServices()
				 * .getComponent(connName));
				 */
				conn = ArchiveConnectionHelper.narrow(getContainerServices()
						.getDefaultComponent(connTypeName));
			} catch (AcsJContainerServicesEx e) {
				m_logger.log(Level.SEVERE, "Failed to connect to "
						+ connTypeName, e);
				System.out.println("ERROR: Could not connect to "
						+ connTypeName + ":\n" + e.toString());
				System.out
						.println("Running Archive components will not know about new schemas, better restart them.");
				return;
			}
			Administrative admin;
			try {
				admin = conn.getAdministrative("ArchiveSchemaLoader");
			} catch (Exception e) {
				e.printStackTrace();
				// MPA: no logging information
				return;
			}
			try {
				admin.reinit("almabtrieb");
			} catch (ArchiveInternalError e1) {
				e1.printStackTrace();
				// MPA: no logging information
			}
		}
	}

	/**
	 * 
	 */
	public archiveQueryClient() {
		super();
		// TODO Auto-generated constructor stub
	}

	/**
	 * Query the Archive. Uses dbConfig.properties to determine Archive location
	 * and behaviour.
	 * 
	 * Usage archiveQueryClient [-i] [-h] [-c] [-q xPath schemaName] [-r uid]
	 * Exactly one of the arguments -i, -q, -c, or -r must be given.
	 * 
	 * -i: (info) Display information about the used database backend. -h:
	 * (help) Display help information. -q: (query) Query Archive on schemaName
	 * with XPath expressions. Result is a list of matching UIDs, one per line.
	 * additional optional switch -w: insted of printing UIDs to command line,
	 * full XML files are fetched and concatenated to specified file (The UIDs
	 * returned are documents that contain elements matching the XPath.) -r:
	 * (retrieve) Retrieve document with given UID. -c: (clean) cleans test area
	 * 
	 * @param args
	 * @throws DatabaseException
	 * @throws ModuleCriticalException
	 * @throws URISyntaxException
	 * @throws ArchiveException
	 * @throws MalformedURIException
	 * @throws UserDoesNotExistException
	 * @throws EntityDoesNotExistException
	 * @throws EntityDirtyException
	 * @throws PermissionDeniedException
	 * @throws IOException
	 * @throws MessagingException
	 * 
	 */
	public static void main(String[] args) throws PermissionDeniedException,
			EntityDirtyException, EntityDoesNotExistException,
			DatabaseException, UserDoesNotExistException,
			MalformedURIException, ModuleCriticalException, ArchiveException,
			URISyntaxException, IOException, MessagingException,
			AcsJArchiveIdentifierErrorEx {
		// Check that the right number of args have been passed
		if (args.length < 1) {
			System.out.println("ERROR: Wrong number of arguments!");
			displayHelp();
			return;
		}

		Logger logger = ClientLogManager.getAcsLogManager()
				.getLoggerForApplication("DatabaseWriter", false);
		// logger.setLevel(Level.ALL);

		// Now get and initialize the Archive.
		InternalIF xmlstore = InternalIFFactory.getInternalIF(logger);
		xmlstore.init();

		// Get some configuration information
		DBConfiguration dbConfig = DBConfiguration.instance(logger);
		boolean storeInNgast = false;
		String testDirectory = System.getProperty("ACS.tmp");
		String storeInNgast_s = dbConfig.get("archive.ngast.storeInNgast");
		if ("True".equalsIgnoreCase(storeInNgast_s)) {
			storeInNgast = true;
		}
		String testDirectory_s = dbConfig.get("archive.ngast.testDir");
		if (!"".equalsIgnoreCase(testDirectory_s)) {
			testDirectory = testDirectory_s;
		}

		String ngasServer = dbConfig.get("archive.ngast.server");
		// default port for NGAS is 7777
		int ngasPort = (dbConfig.get("archive.ngast.port") == null) ? 7777
				: Integer.parseInt(dbConfig.get("archive.ngast.port"));

		if (args[0].indexOf("i") != -1) {
			System.out.println(InternalIFFactory.dbConfig.toString());
			return;
		}

		if (args[0].indexOf("h") != -1) {
			displayHelp();
			return;
		}

//		if ((args[0].indexOf("r") != -1) || (args[0].indexOf("d") != -1)) {
//			/*
//			 * To retrive a document, first see if it ins in the XmlStore all
//			 * documents are there, check the schema type is it is a VOTable
//			 * then go have a look in NGAST as well return the NGAST stuff if it
//			 * is available.
//			 */
//			if (args.length != 2) {
//				System.out.println("ERROR: Wrong number of arguments!");
//				displayHelp();
//				return;
//			}
//			URI uid = new URI(args[1]);
//			JClient ngasJClient = new JClient(ngasServer, ngasPort, 0, "",
//					null, logger);
//			DocumentFinder finder = new DocumentFinder(xmlstore, ngasJClient,
//					logger, storeInNgast, testDirectory);
//
//			finder.addNgasType("VOTable");
//
//			// mist be a better way of printing this
//			InputStream str = finder.fetch(uid);
//			if (args[0].indexOf("r") != -1) {
//				MimeBodyPart mp = new MimeBodyPart(str);
//				MimeMultipart mmp = (MimeMultipart) mp.getContent();
//				String idString = mp.getHeader("alma-uid")[0];
//				System.out.println(idString);
//				String xml = (String) mmp.getBodyPart(0).getContent();
//				System.out.println(xml);
//			}
//			if (args[0].indexOf("d") != -1) {
//				int i;
//				while ((i = str.read()) != -1) {
//					System.out.print(i);
//				}
//			}
//			return;
//		}

		String query;
		int indexAfterQuery = 2; // if query spreads over several args, this
									// variable is changed
		if (args[0].indexOf("q") != -1) {
			if (args.length < 3) {
				System.out.println("ERROR: Wrong number of arguments!");
				displayHelp();
				return;
			}
			if (args[1].startsWith("{")) {
				// special case: query can be enclosed by { and }
				// in this case, all the following args up to } are considered
				// as part of the query
				StringBuffer queryBuf = new StringBuffer();
				int i;
				for (i = 1; i < args.length && !args[i - 1].endsWith("}"); i++) {
					queryBuf.append(args[i]).append(" ");
					;
				}
				if (queryBuf.charAt(queryBuf.length() - 2) != '}') {
					// error: does not end with }
					System.out.println("ERROR: no closing } found.");
					displayHelp();
					return;
				}
				indexAfterQuery = i;
				// finally, remove { and }:
				query = queryBuf.toString().substring(1, queryBuf.length() - 2);
			} else {
				query = args[1];
			}

			// remove enclosing ":
			if (query.startsWith("\"") && query.endsWith("\"")) {
				query = query.substring(1, query.length() - 1);
			}
			// if we write to a file:
			FileWriter out = null;
			if (args.length > indexAfterQuery + 1
					&& args[indexAfterQuery + 1].indexOf("w") != -1) {
				out = new FileWriter(args[indexAfterQuery + 2]);
				System.out
						.println("Writing matching XML files contents to file "
								+ args[indexAfterQuery + 2]);
			}

			SchemaManager smanager = InternalIFFactory.getInternalIF(logger)
					.getSchemaManager("archiveClient");

			URI schemaURI = smanager.getSchemaURI(args[indexAfterQuery]);
			HashMap namespaces = smanager.getSchemaNamespaces(schemaURI);
			// System.out.println("=========NAMESPACES======");
			for (Iterator it = namespaces.keySet().iterator(); it.hasNext();) {
				String key = (String) it.next();
				System.out.println(key + " : " + namespaces.get(key));
			}

			// query archive
			DBCursor cursor = xmlstore.query(query, args[indexAfterQuery],
					namespaces, false, "archiveClient");
			// print cursor contents:
			while (cursor.hasNext()) {
				ResultStruct next = cursor.next();
				System.out.println(next.getUri());
				if (out != null) {
					// write to file
					// first retrieve full doc
					// xmlstore.get(next.getXml(), "archiveClient");
					// next write full doc to file
					out.write(next.getXml());
				}
			}
			if (out != null) {
				out.close();
			}
			cursor.close();
			return;
		}
		if (args[0].indexOf("x") != -1) {
			if (args.length != 2) {
				System.out.println("ERROR: Wrong number of arguments!");
				displayHelp();
				return;
			}
			// retrieve XML document with given UID, no NGAMS connection or
			// whatsoever
			System.out.println(xmlstore.get(new URI(args[1]), "archiveClient"));
		}

		if (args[0].indexOf("c") != -1) {
			xmlstore.cleanTestArea("directClient");
			// check whether ACS is running and inform running Archive
			// components

			// get location of manager
			if (System.getProperty("ACS.manager") != null) {
				String managerLoc = System.getProperty("ACS.manager").trim();
				System.out
						.println("Archive SchemaLoader: Trying to inform ACS components.");

				// PrintStream origStdout = System.out;
				try {
					// PrintStream nullPrintStream = new PrintStream(new
					// ByteArrayOutputStream(0));
					// System.setOut(nullPrintStream);
					AcsClient client = (new alma.archive.client.archiveQueryClient()).new AcsClient(
							null, managerLoc, "ArchiveClient");
					// System.setOut(origStdout);
					client.informACScomponents();
					System.out.println("Archive/ACS component informed.");
				} catch (Exception e) {
					// System.setOut(origStdout);
					System.out
							.println("ACS not running or not available. No Archive components informed about test area been cleaned.");
					// MPA: no logging info
				}
			} else {
				System.out
						.println("Archive SchemaLoader: Running in standalone mode.");
			}
		}

		return;
	}

	/**
	 * 
	 */
	private static void displayHelp() {
		System.out
				.println("Usage: archiveQuery [-i] [-h] [-q XPathQuery schemaName [-w fileName]] [-r UID] [-x UID]");
		System.out.println("Command line options are mutual exclusive.");
		System.out
				.println("  -i (INFO):     displays information about database backend.");
		System.out.println("  -h (HELP):     displays this text.");
		System.out.println("  -c (CLEAN) cleans test area.");
		System.out
				.println("  -q (QUERY):    queries the Archive with an XPath query and a schema name. If -w is given, paste full files into specified file. If the XPath query contains blanks, it must be enclosed in { and }, see example below.");
		System.out
				.println("  -r (RETRIEVE): retrieves the xml content of a document from the Archive");
		System.out
				.println("  -d (DATA-RETRIEVE): retrieves all of the data associated with a particular UID");
		System.out
				.println("  -x (XML-RETRIEVE): retrieves XML document for UID");
		System.out
				.println("EXAMPLE: archiveQuery -q {\\\"/ObsProject[./ProjectName=\"OPT - 6 bright polar stars\"][./pI=\"1 bright investigator\"]\\\"} ObsProject");
	}
}
