/*
 * 	  Created on 09-May-2003
 * 
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 */
package alma.archive.client;

import java.util.logging.Logger;

import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

import alma.archive.database.xmldb.XmldbConnector;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.general.DatabaseException;

/**
 * @author simon
 */
public class XmldbDirectClient
{
	private XmldbConnector connector = null;

	private Collection descriptor = null;
	private Collection latest = null;
	private Collection documents = null;
	
	private static Logger logger = Logger.getAnonymousLogger();	
	
	public XmldbDirectClient(boolean testMode) 
		throws 
			DatabaseException, 
			XMLDBException
	{
		connector = connector = XmldbConnector.instance(logger,testMode);
		descriptor = connector.getDescriptor();
		latest = connector.getLatest();
		documents = connector.getDocuments();
	}
	
	private String printres(Resource res) throws XMLDBException
	{
		if (res == null) return "null";
		return (String)res.getContent();
	}
	
	public void list() throws ArchiveException
	{
	    //MPA: ArchiveException is never thrown by this method !!!
		String[] res;
		
		try
		{
			res = descriptor.listResources();
			for (int x = 0; x < res.length; x++)
			{
				String out = res[x];
				
				String xml = printres(descriptor.getResource(res[x]));
				
				out = "Descriptor:  " + out + "     "  +  xml;
				System.out.println(out);
			}
			
			res = latest.listResources();
			for (int x = 0; x < res.length; x++)
			{
				String out = res[x];
	
				String xml = printres(latest.getResource(res[x]));
	
				out = "Latest:   " + out + "     " +  xml;
				System.out.println(out);
			}
			
			res = documents.listResources();
			for (int x = 0; x < res.length; x++)
			{
				String out = res[x];
	
				String xml = printres(documents.getResource(res[x]));
	
				out = "Documents:   " + out + "     " +  xml;
				System.out.println(out);
			}
		} 
		catch (XMLDBException e)
		{
			e.printStackTrace();
			// MPA: no logging message and not rethrown. is it enough?
		}
	}
	
	public void scruball() throws DatabaseException
	{
		connector.cleanCollections();
	}
	
	public void scrubtest() throws DatabaseException
	{
		connector.cleanTestCollections();
	}
	
	
	public static void main(String[] args) 
	{
		try
		{
			if (args.length > 0){
			
				boolean testMode = true;
				if (args[1].equalsIgnoreCase("all")){
					testMode = false;
				}
				XmldbDirectClient client = new XmldbDirectClient(testMode);
				
				if (args[0].equalsIgnoreCase("view"))
				{
					client.list();
				}
				else if (args[0].equalsIgnoreCase("scrub"))
				{
					if (testMode){
						client.scrubtest();
					}
					else{
						client.scruball();
					}
					System.out.println("Archive Cleaned");
				}
			}
		}
		catch (DatabaseException e){
		    //MPA: no logging message, no action, no dealing with the exceptio. Is it correct?
			//return 0;
		}
		catch (XMLDBException e){
            //MPA: no logging message, no action, no dealing with the exceptio. Is it correct?
			//return 0;
		}
		catch (ArchiveException e){
            //MPA: no logging message, no action, no dealing with the exceptio. Is it correct?
			//return 0;
		}
		//return 1;
	}
}
