package alma.userrepository;

/**
 * XML binding class aware ACS component interface ProjectDirectoryJ */
public interface ProjectDirectoryJ extends alma.ACS.ACSComponentOperations
{
    /**
     * Check connectivity to the back-end database.
     * 
     * @returns  true if the server is alive and is responding
     * correctly.
     */
    public boolean isAlive();

    /**
     * Establish an connection to the project directory. A unique
     * identifier corresponding to the open connection is
     * returned. Most user repository operations require a valid
     * non-anonymous, authenticated connection to complete
     * successfully. Note that the connection is NOT closed on
     * completion of this method.
     * 
     * @param  uid the uid of the user to connect as
     * 
     * @param  password the user's password
     * 
     * @return  the connection's unique identifier
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while establishing the connection
     */
    public String createConnection(String uid, String password)
        throws alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Close a connection to the project directory. This method
     * instructs the connection manager to close the connection
     * referenced by the unique ID and allows the connection
     * manager to free its internal references to it. The
     * behaviour of subsequent functions called using a closed
     * connection is undefined.
     * 
     * @param  connectionId the connection ID
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while releasing the connection.
     */
    public void releaseConnection(String connectionId)
        throws alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * List the ids of all projects in the directory.
     * 
     * @param  connectionId the connection ID
     * 
     * @returns  the list of project ids
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while listing the projects.
     */
    public alma.ProjectCodeModule.ProjectCodeStruct[] getAllProjects(String connectionId)
        throws alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * List the ids of all projects in the directory registered with the given year and semester
     * 
     * @param  connectionId the connection ID
     * 
     * @param  year a long being the year of interest
     * 
     * @param  semester a long being the semester of interest
     * 
     * @returns  the list of project ids
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while listing the projects.
     */
    public alma.ProjectCodeModule.ProjectCodeStruct[] getProjects(String connectionId, int year, int semester)
        throws alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Determine whether a project with the given id exists.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  projectCode the project code
     * 
     * @return  true if a project with the given ID exists
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while searching for the project.
     */
    public boolean exists(String connectionId, alma.ProjectCodeModule.ProjectCodeStruct projectCode)
        throws alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * List the project members with the given project role.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  projectCode the project code
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while determing the project members.
     */
    public alma.userrepository.ProjectRoleStruct getProjectMembers(String connectionId, alma.ProjectCodeModule.ProjectCodeStruct projectCode)
        throws alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Assign a user to the specified project role of the given project.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  userId the user id to assign
     * 
     * @param  projectRole the project role to assign to
     * 
     * @param  projectCode the project code
     * 
     * @return  a boolean indicating if the stated member was added;
     * <code>true</code> if the user did not exist and was added,
     * <code>false</code> otherwise.
     * 
     * @throws  ObjectNotFoundErrorEx if the project cannot be
     * found
     * 
     * @throws  PermissionErrorEx if the connection does not have
     * the privileges required to perform this operation
     * 
     * @throws  UserRepositoryErrorEx if the server raises an error
     * while performing this operation
     */
    public boolean addProjectUserMember(String connectionId, String userId, alma.userrepository.ProjectRoleEnum projectRole, alma.ProjectCodeModule.ProjectCodeStruct projectCode)
        throws alma.UserRepositoryError.ObjectNotFoundErrorEx, alma.UserRepositoryError.PermissionErrorEx, alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Assign a role group to the specified project role of the given project.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  role the role group to assign
     * 
     * @param  projectRole the project role to assign to
     * 
     * @param  projectCode the project code
     * 
     * @return  a boolean indicating if the stated member was added;
     * <code>true</code> if the user did not exist and was added,
     * <code>false</code> otherwise.
     * 
     * @throws  ObjectNotFoundErrorEx if the project cannot be
     * found
     * 
     * @throws  PermissionErrorEx if the connection does not have
     * the privileges required to perform this operation
     * 
     * @throws  UserRepositoryErrorEx if the server raises an error
     * while performing this operation
     */
    public boolean addProjectRoleMember(String connectionId, alma.userrepository.UserRole role, alma.userrepository.ProjectRoleEnum projectRole, alma.ProjectCodeModule.ProjectCodeStruct projectCode)
        throws alma.UserRepositoryError.ObjectNotFoundErrorEx, alma.UserRepositoryError.PermissionErrorEx, alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Remove a user from the specified project role in the given project.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  userId the user id to remove
     * 
     * @param  projectRole the project role to remove from
     * 
     * @param  projectCode the project code
     * 
     * @return  a boolean indicating if the stated member was removed;
     * <code>true</code> if the user existed and was removed,
     * <code>false</code> otherwise.
     * 
     * @throws  ObjectNotFoundErrorEx if the project cannot be
     * found
     * 
     * @throws  PermissionErrorEx if the connection does not have
     * the privileges required to perform this operation
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while removing the project member
     */
    public boolean removeProjectUserMember(String connectionId, String userId, alma.userrepository.ProjectRoleEnum projectRole, alma.ProjectCodeModule.ProjectCodeStruct projectCode)
        throws alma.UserRepositoryError.ObjectNotFoundErrorEx, alma.UserRepositoryError.PermissionErrorEx, alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Remove a role group from the specified project role in the given project.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  role the role group to remove
     * 
     * @param  projectRole the project role to remove from
     * 
     * @param  projectCode the project code
     * 
     * @return  a boolean indicating if the stated member was removed;
     * <code>true</code> if the user existed and was removed,
     * <code>false</code> otherwise.
     * 
     * @throws  ObjectNotFoundErrorEx if the project cannot be
     * found
     * 
     * @throws  PermissionErrorEx if the connection does not have
     * the privileges required to perform this operation
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while removing the project member
     */
    public boolean removeProjectRoleMember(String connectionId, alma.userrepository.UserRole role, alma.userrepository.ProjectRoleEnum projectRole, alma.ProjectCodeModule.ProjectCodeStruct projectCode)
        throws alma.UserRepositoryError.ObjectNotFoundErrorEx, alma.UserRepositoryError.PermissionErrorEx, alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Create a new project and return the project code for this project.
     * The project is created with empty membership lists for all roles available.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  projectPI a string stating the user to be assigned as the primary investigator.
     * 
     * @param  projectType an enum specifying what type of project to create.
     * 
     * @return  the project ID of the newly created project
     * 
     * @throws  InvalidAttributeEx if projectCode is in an invalid
     * format
     * 
     * @throws  PermissionErrorEx if the connection does not have
     * the privileges required to perform this operation
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while creating the project
     */
    public alma.ProjectCodeModule.ProjectCodeStruct createProject(String connectionId, String projectPI, alma.ProjectCodeModule.ProjectTypeCodeEnum projectType)
        throws alma.UserRepositoryError.InvalidAttributeErrorEx, alma.UserRepositoryError.PermissionErrorEx, alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Removes the project with the stated project code.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  projectCode the project code of the project to remove
     * 
     * @throws  InvalidAttributeEx if projectCode is in an invalid
     * format
     * 
     * @throws  PermissionErrorEx if the connection does not have
     * the privileges required to perform this operation
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while creating the project
     */
    public void removeProject(String connectionId, alma.ProjectCodeModule.ProjectCodeStruct projectCode)
        throws alma.UserRepositoryError.InvalidAttributeErrorEx, alma.UserRepositoryError.PermissionErrorEx, alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Resets the internal values in the project code generator to whatever
     * values are stored in LDAP.
     * 
     * @param  connectionId the connection ID
     * 
     * @throws  UserRepositoryErrorEx
     * if an error occurs during the operation
     */
    public void resetSubmissionPeriod(String connectionId)
        throws alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * ACS will not generate the Castor xxxJ binding classes unless there
     * is at least one method with an out parameteter. When the methods
     * are all 'in's, they binding classes are not compiled into the
     * library.
     */
    public void junkMethodSoWeGenerateBindingClass(alma.xmljbind.userrepository.user.User junkIn, org.omg.CORBA.StringHolder junkOut);

}
