package alma.userrepository;

/**
 * XML binding class aware ACS component interface AddressBookJ */
public interface AddressBookJ extends alma.ACS.ACSComponentOperations
{
    /**
     * Check connectivity to the back-end database.
     * 
     * @returns  true if the server is alive and is responding
     * correctly.
     */
    public boolean isAlive();

    /**
     * Authenticate a user using a username and password.
     * 
     * @param  uid the uid of the user
     * 
     * @param  password the user's password
     * 
     * @return  true if the username/password combination is valid
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while performing this operation.
     */
    public boolean authenticate(String uid, String password)
        throws alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Establish an connection to the user repository. A unique
     * identifier corresponding to the open connection is
     * returned. Most user repository operations require a valid
     * non-anonymous, authenticated connection to complete
     * successfully. Note that the connection is NOT closed on
     * completion of this method. 
     * 
     * @param  uid the uid of the user to connect as
     * 
     * @param  password the user's password
     * 
     * @return  the connection's unique identifier
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while establishing the connection
     */
    public String createConnection(String uid, String password)
        throws alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Close a connection to the user repository. This method
     * instructs the connection manager to close the connection
     * referenced by the unique ID and allows the connection
     * manager to free its internal references to it. The
     * behaviour of subsequent functions called using a closed
     * connection is undefined.
     * 
     * @param  connectionId the connection ID
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while releasing the connection.
     */
    public void releaseConnection(String connectionId)
        throws alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * List all users in the address book. This function returns
     * the uid of all users.
     * 
     * @returns  the list of user uids
     * 
     * @param  connectionId the connection ID
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while performing this operation
     */
    public String[] listUsers(String connectionId)
        throws alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Determine whether a user with the given uid exists in the
     * address book.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  uid the uid to search for
     * 
     * @return  true if a user with the given by the uid already
     * exists
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while performing the search.
     */
    public boolean exists(String connectionId, String uid)
        throws alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Locate users in the address book whose details match the
     * given search filter.
     * 
     * @returns  the location of users matching the search filter
     * 
     * @param  connectionId the connection ID
     * 
     * @param  searchFilter the search filter to use
     * 
     * @throws  InvalidSearchFilterErrorEx if the given search
     * filter is invalid
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while performing the search.
     */
    public String[] searchGetLocation(String connectionId, String searchFilter)
        throws alma.UserRepositoryError.InvalidSearchFilterErrorEx, alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Return the requested attribute of users matching the
     * given search filter.
     * 
     * @returns  the specified attributes of users matching the
     * search filter
     * 
     * @param  connectionId the connection ID
     * 
     * @param  searchFilter the search filter to use
     * 
     * @param  attr the attribute to return
     * 
     * @throws  InvalidSearchFilterErrorEx if the given search
     * filter is invalid
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurrs while performing the search.
     */
    public String[] searchGetAttribute(String connectionId, String searchFilter, String attr)
        throws alma.UserRepositoryError.InvalidSearchFilterErrorEx, alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Return the requested attributes of entries matching the
     * given search filter, beginning the search from the given
     * location.
     * 
     * @returns  the specified attributes of users matching the
     * search filter
     * 
     * @param  connectionId the connection ID
     * 
     * @param  searchBase the place to begin the search
     * 
     * @param  searchFilter the search filter to use
     * 
     * @param  attr the attribute to return
     * 
     * @throws  InvalidSearchFilterErrorEx if the given search
     * filter is invalid
     * 
     * @throws  ObjectNotFoundErrorEx if the given search
     * base cannot be found
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while performing the search.
     */
    public String[] searchLocationGetAttribute(String connectionId, String searchBase, String searchFilter, String attr)
        throws alma.UserRepositoryError.ObjectNotFoundErrorEx, alma.UserRepositoryError.InvalidSearchFilterErrorEx, alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Retrieve a User from the address book. This function does not 
     * retrieve the user address details.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  uid the uid of the user to retrieve
     * 
     * @return  the User object corresponding to the user
     * 
     * @throws  ObjectNotFoundErrorEx if a user with the specified
     * uid cannot be found
     * 
     * @throws  PermissionErrorEx if the connection does not have
     * the privileges required to perform this operation
     * 
     * @throws  UserRepositoryErrorEx if the server reports an
     * error while performing this operation
     */
    public alma.xmljbind.userrepository.user.User getUser(String connectionId, String uid)
        throws alma.UserRepositoryError.ObjectNotFoundErrorEx, alma.UserRepositoryError.PermissionErrorEx, alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Retrieve a AddressBookEntry from the address book.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  uid the uid of the user to retrieve
     * 
     * @return  the AddressBookEntry object corresponding to the
     * user
     * 
     * @throws  ObjectNotFoundErrorEx if a user with the specified
     * uid cannot be found
     * 
     * @throws  PermissionErrorEx if the connection does not have
     * the privileges required to perform this operation
     * 
     * @throws  UserRepositoryErrorEx if the server reports an
     * error while performing this operation
     */
    public alma.userrepository.AddressBookEntryJ getEntry(String connectionId, String uid)
        throws alma.UserRepositoryError.ObjectNotFoundErrorEx, alma.UserRepositoryError.PermissionErrorEx, alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Retrieve a user's Preferences from the address book.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  uid the uid of the user to retrieve
     * 
     * @return  the Preferences object corresponding to the user
     * 
     * @throws  ObjectNotFoundErrorEx if a user with the specified
     * uid cannot be found
     * 
     * @throws  PermissionErrorEx if the connection does not have
     * the privileges required to perform this operation
     * 
     * @throws  UserRepositoryErrorEx if the server reports an
     * error while performing this operation
     */
    public alma.xmljbind.userrepository.preferences.Preferences getPreferences(String connectionId, String uid)
        throws alma.UserRepositoryError.ObjectNotFoundErrorEx, alma.UserRepositoryError.PermissionErrorEx, alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Set the password for the user with the given uid. The
     * password can only be changed by an administrator or by the
     * user themselves.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  uid the uid of the user
     * 
     * @param  password the password to set
     * 
     * @throws  ObjectNotFoundErrorEx if a user with the specified
     * uid cannot be found
     * 
     * @throws  PermissionErrorEx if the connection does not have
     * the privileges required to perform this operation
     * 
     * @throws  UserRepositoryErrorEx if the server reports an
     * error while performing this operation
     */
    public void setPassword(String connectionId, String uid, String password)
        throws alma.UserRepositoryError.ObjectNotFoundErrorEx, alma.UserRepositoryError.PermissionErrorEx, alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Commit a AddressBookEntry object to the address book. This
     * function writes a new entry if it does not exist on the
     * server, and overwrites existing attribute values should the
     * AddressBookEntry object represent an existing entry.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  entry the AddressBookEntry to commit
     * 
     * @throws  PermissionErrorEx if the connection does not have
     * the privileges required to perform this operation
     * 
     * @throws  UserRepositoryErrorEx if the server raises an error
     * while performing this operation
     */
    public void commitEntry(String connectionId, alma.userrepository.AddressBookEntryJ entry)
        throws alma.UserRepositoryError.PermissionErrorEx, alma.UserRepositoryError.DataExpiredErrorEx, alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Delete an entry from the address book. This function
     * deletes the user plus all associated addresses from the
     * address book.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  entry the AddressBookEntry of the user to delete
     * from the server.
     * 
     * @throws  ObjectNotFoundErrorEx if the user cannot be found
     * 
     * @throws  PermissionErrorEx if the connection does not have
     * the privileges required to perform this operation
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while deleting the user.
     */
    public void deleteEntry(String connectionId, alma.userrepository.AddressBookEntryJ entry)
        throws alma.UserRepositoryError.ObjectNotFoundErrorEx, alma.UserRepositoryError.PermissionErrorEx, alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Delete the entry of the user with the given uid from the
     * address book. This function deletes the user plus all
     * associated addresses from the address book.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  uid the user's uid
     * 
     * @throws  ObjectNotFoundErrorEx if the user cannot be found
     * 
     * @throws  PermissionErrorEx if the connection does not have
     * the privileges required to perform this operation
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while deleting the user.
     */
    public void deleteEntryByUid(String connectionId, String uid)
        throws alma.UserRepositoryError.ObjectNotFoundErrorEx, alma.UserRepositoryError.PermissionErrorEx, alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * ACS will not generate the Castor xxxJ binding classes unless there
     * is at least one method with an out parameteter. When the methods
     * are all 'in's, they binding classes are not compiled into the
     * library.
     */
    public void junkMethodSoWeGenerateBindingClass(alma.xmljbind.userrepository.user.User junkIn, org.omg.CORBA.StringHolder junkOut);

}
