/**
 * @author  Pablo Burgos
 * @version %I%,%G%
 * @since ACS-8_0_0-B
 *
 */
package alma.archive.tmcdb.DAO;

import java.util.ArrayList;
import alma.TMCDB.legacy.TimeValue;

public interface TimeValuePager {


  public ArrayList<TimeValue> getValues();

  public int getCurrentPageNumber();

  public void setCurrentPageNumber(int pageNumber);

  public int getTotalNumberOfPages();

  public int getPageSize();

  public String getMonitorPointName();

  public boolean hasNextPage();

  public boolean hasPreviousPage();

  public DataType getDataType();

  public TimeValuePager getNextPage();

  public TimeValuePager getPreviousPage();

  public enum DataType {
    /**
     * Boolean (true/false) property type.
     */
    BOOLEAN,

    /**
     * Double property type.
     */
    DOUBLE,

    /**
     * Float property type.
     */
    FLOAT,

    /**
     * Integer property type.
     */
    INTEGER,

    /**
     * Character string property type.
     */
    STRING,
    /**
     * Unknown Datatype. This case should be checked.
     */
    UNKNOWN;
  }
}

