package alma.archive.tmcdb.DAO;

import java.util.logging.Logger;
import javax.persistence.*;
import alma.archive.tmcdb.Persistence.Util.*;
import alma.DAOErrType.wrappers.*;

public class MonitorDAOImplTest extends MonitorDAOImpl {

    public MonitorDAOImplTest(Logger inLogger) {
        super(inLogger);
    }

    // overriding this method because ACS is not started in the unit tests
    public String getComponentIDL(String componentName)
	throws
	    Exception
    {
	String assemblyCode = componentName.substring(componentName.lastIndexOf("/") + 1);
	String assemblyIDL = "";
            /* ACME device is used for running unit tests*/
	if (assemblyCode.equalsIgnoreCase("ACME"))
	    assemblyIDL = "IDL:alma/Control/ACME:1.0";

	return assemblyIDL;
    }
    
    public Long configureNewAssembly(MonitorCharacteristicIDs monitorCharacteristicIDs,
				      ComponentData inData)
	throws
	    AcsJDynConfigFailureEx
    {
	return super.configureNewAssembly(monitorCharacteristicIDs,inData);
    }

    public MonitorCharacteristicIDs getMonitorCharacteristicIDs(EntityManager entityManagerStore,
                                                                 String configurationName, 
								 ComponentData inData) 
	throws
	    AcsJGettingMonitorCharacteristicsEx,
	    AcsJDynConfigFailureEx
    {
	return super.getMonitorCharacteristicIDs(entityManagerStore,configurationName,inData);
    }
    
}