package alma.archive.tmcdb.DAO;

import alma.acs.component.client.ComponentClient;
import alma.acs.container.ContainerServices;
import alma.acs.component.ComponentDescriptor;

public class ComponentResolver extends ComponentClient
{
    static ContainerServices containerServices;
    static private ComponentResolver resolver = null;
    static String managerLoc = System.getProperty("ACS.manager");
    static String clientLoc = "ComponentResolver";

    private ComponentResolver() throws Exception {
	super(null, managerLoc, clientLoc);
	containerServices = getContainerServices();
    }

    static public ComponentResolver getResolver() throws Exception {
	if (resolver == null)
	    resolver = new ComponentResolver();
	return resolver;
    }

    public String resolve(String componentName) throws Exception {
        return containerServices.getComponentDescriptor(componentName).getType();
    }
}