/**
 * 
 */
package com.cosylab.cdb.jdal.hibernate.plugin;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import alma.TMCDB.baci.AmbDevice;
import alma.TMCDB.baci.BACIPropertyType;
import alma.TMCDB.baci.ComponentData;
import alma.TMCDB.baci.EmptyStringHandlerBACIPropertyType;
import alma.acs.logging.AcsLogLevel;
import alma.acs.tmcdb.Component;
import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.DefaultCanAddress;
import alma.acs.tmcdb.Startup;
import alma.acs.tmcdb.AssemblyRole;
import alma.acs.tmcdb.BaseElementStartup;
import alma.acs.tmcdb.AssemblyStartup;
import alma.cdbErrType.CDBFieldDoesNotExistEx;
import alma.cdbErrType.CDBRecordDoesNotExistEx;
import alma.cdbErrType.CDBXMLErrorEx;

import com.cosylab.CDB.DAO;
import com.cosylab.cdb.client.CDBAccess;
import com.cosylab.cdb.jdal.hibernate.DBUtil;

/**
 * @author msekoranja
 *
 */
public class HibernateWDALPluginImpl implements HibernateWDALPlugin {

	static final String TMCDB_STARTUP_NAME_KEY = "TMCDB_STARTUP_NAME";

	private Logger m_logger = Logger.getLogger(Logger.GLOBAL_LOGGER_NAME);
	
	/* (non-Javadoc)
	 * @see com.cosylab.cdb.jdal.hibernate.plugin.HibernateWDALPlugin#getName()
	 */
	public String getName() {
		return "ALMA HW section plugin";
	}

	/* (non-Javadoc)
	 * @see com.cosylab.cdb.jdal.hibernate.plugin.HibernateWDALPlugin#initialize(java.util.logging.Logger)
	 */
	public void initialize(Logger logger) {
		this.m_logger = logger;
	}

	/* (non-Javadoc)
	 * @see com.cosylab.cdb.jdal.hibernate.plugin.HibernateWDALPlugin#importEpilogue(org.hibernate.Session, alma.acs.tmcdb.Configuration, com.cosylab.cdb.client.CDBAccess)
	 */
	public void importEpilogue(Session session, Configuration config, CDBAccess cdbAccess) {
		// noop
	}

	/* (non-Javadoc)
	 * @see com.cosylab.cdb.jdal.hibernate.plugin.HibernateWDALPlugin#importPrologue(org.hibernate.Session, alma.acs.tmcdb.Configuration, com.cosylab.cdb.client.CDBAccess)
	 */
	public void importPrologue(Session session, Configuration config, CDBAccess cdbAccess) {
		// noop
	}

	/* (non-Javadoc)
	 * @see com.cosylab.cdb.jdal.hibernate.plugin.HibernateWDALPlugin#loadControlDevices(org.hibernate.Session, alma.acs.tmcdb.Configuration, com.cosylab.cdb.jdal.hibernate.plugin.HibernateWDALPlugin.ControlDeviceBindCallback)
	 */
	public void loadControlDevices(Session session, Configuration config, ControlDeviceBindCallback bindCallback) {
	 	String startupName = System.getProperty(TMCDB_STARTUP_NAME_KEY);
	    if (startupName == null) {
	        m_logger.log(AcsLogLevel.NOTICE, "No Startup Scenario has been defined through property " + TMCDB_STARTUP_NAME_KEY);
	    } else {
	        m_logger.config("Using startup scenario '" + startupName + "'.");
	    }
		
        List compList = session.createCriteria(Component.class)
                               .add(Restrictions.eq("isControl", true))
                               .add(Restrictions.eq("configuration", config)).list();
	    for (Iterator iter = compList.iterator(); iter.hasNext(); ) {
	        Component component = (Component) iter.next();
	        String query = "FROM " + BACIPropertyType.class.getName() + " WHERE ComponentId = " + component.getComponentId();
	        List propList = session.createQuery(query).list();
	        if (propList.size() > 0) {
	            AmbDevice ambDevice = new AmbDevice();
	 			try {
					ambDevice.setData(component.getXMLDoc());
				} catch (Throwable e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

	            for (Iterator iter2 = propList.iterator(); iter2.hasNext(); ) {
	                BACIPropertyType baciProperty = (BACIPropertyType) iter2.next();
	                //ambDevice._.put(baciProperty.PropertyName, baciProperty);
	                ambDevice._.put(baciProperty.PropertyName, new EmptyStringHandlerBACIPropertyType(baciProperty));
	            }
	            boolean isEthernet = false;
	            String nodeAddress = "0";
	            String baseAddress = "0";
	            int channelNumber = 0;
	        	String hostname = "";
	        	int port = 0;
	        	String macAddress = "";
	        	int retries = 0;
	        	double timeoutRxTx = 0.0;
	        	int lingerTime = 0;
		        List addressList = session.createCriteria(DefaultCanAddress.class)
		                .add(Restrictions.eq("componentId", component.getComponentId())).list();
	            if (addressList.size() > 0) {
	                DefaultCanAddress address = (DefaultCanAddress) addressList.get(0);
	                isEthernet = address.getIsEthernet();
	                nodeAddress = address.getNodeAddress();
	                channelNumber = address.getChannelNumber();
	                hostname = address.getHostname();
	                port = address.getPort();
	                macAddress = address.getMacAddress();
	                retries = address.getRetries();
	                timeoutRxTx = address.getTimeOutRxTx();
	                lingerTime = address.getLingerTime();
	            }
	            if (!isEthernet) {
		            AmbDevice.AmbAddress ambAddress = new AmbDevice.AmbAddress();
		            ambAddress.setNodeNumber(Integer.parseInt(nodeAddress));
		            ambAddress.setBaseAddress(Integer.parseInt(baseAddress));
		            ambAddress.setChannelNumber(channelNumber);
		            ambDevice.setAddress(ambAddress);
	            } else {
		            AmbDevice.EthernetAddress ethAddress = new AmbDevice.EthernetAddress();
		            ethAddress.setHostname(hostname);
		            ethAddress.setPort(port);
		            ethAddress.setMacAddress(macAddress);
		            ethAddress.setRetries(retries);
		            ethAddress.setTimeoutRxTx(timeoutRxTx);
		            ethAddress.setLingerTime(lingerTime);
		            ambDevice.setEthernetConfig(ethAddress);
	            }
	            if (component.getXMLDoc() != null) {
		            try {
						ambDevice.setControlCdbExtraData(component.getXMLDoc());
					} catch (Throwable ex) {
						ex.printStackTrace();
					}
	            }	            
	            bindCallback.bindToComponentBranch(
	                             component.getComponentName(),
	                             component.getPath(),
	                             ambDevice);
	        } else if (component.getXMLDoc() != null) {
	            bindCallback.bindNonExpandedXMLToComponentBranch(session, component);
	        }
	    }
	}

	/* (non-Javadoc)
	 * @see com.cosylab.cdb.jdal.hibernate.plugin.HibernateWDALPlugin#controlDeviceImportEpilogue(org.hibernate.Session, alma.acs.tmcdb.Configuration, com.cosylab.cdb.client.CDBAccess, java.lang.String, alma.TMCDB.generated.Component)
	 */
	public void controlDeviceImportEpilogue(Session session, Configuration config,
			CDBAccess cdbAccess, String componentName, Component component) {
		m_logger.info("Creating DAO for CONTROL device " + componentName);
	    Boolean isEthernet = false;
	    String nodeAddress = "-1";
	    Byte channelNumber = -1;
	    String hostname = "not set";
	    Integer port = -1;
	    String macAddress = "not set";
	    Short retries = -1;
	    Double timeOutRxTx = -1.0;
	    Integer lingerTime = -1;
		try {
			try {
				DAO deviceAddressDAO = cdbAccess.getDAL().get_DAO_Servant("alma/" + componentName + "/Address");
				nodeAddress = deviceAddressDAO.get_string("NodeNumber");
				channelNumber = (byte) deviceAddressDAO.get_long("ChannelNumber");
			} catch (CDBRecordDoesNotExistEx e) {
				isEthernet = true;
				DAO devEtherConfigDAO = cdbAccess.getDAL().get_DAO_Servant("alma/" + componentName + "/EthernetConfig");
				hostname = devEtherConfigDAO.get_string("hostname");
				port = devEtherConfigDAO.get_long("port");
				macAddress = devEtherConfigDAO.get_string("macAddress");
				retries = (short) devEtherConfigDAO.get_long("retries");
				timeOutRxTx = devEtherConfigDAO.get_double("timeoutRxTx");
				lingerTime = devEtherConfigDAO.get_long("lingerTime");
			} 
		} catch( Exception ex ) {
			m_logger.finer("Failed to read 'alma/" + componentName + "/Address|EthernetConfig'");
		}

		DefaultCanAddress defAdd = new DefaultCanAddress();
		defAdd.setIsEthernet(isEthernet);
		defAdd.setComponent(component);
		defAdd.setNodeAddress(nodeAddress);
		defAdd.setChannelNumber((byte)channelNumber);
		defAdd.setHostname(hostname);
		defAdd.setPort(port);
		defAdd.setMacAddress(macAddress);
		defAdd.setRetries(retries);
		defAdd.setTimeOutRxTx(timeOutRxTx);
		defAdd.setLingerTime(lingerTime);
		session.persist(defAdd);
	}

	/* (non-Javadoc)
	 * @see com.cosylab.cdb.jdal.hibernate.plugin.HibernateWDALPlugin#loadEpilogue(org.hibernate.Session, alma.acs.tmcdb.Configuration, java.util.Map)
	 */
	public void loadEpilogue(Session session, Configuration config, Map<String, Object> rootMap) {
		// noop
	}

	/* (non-Javadoc)
	 * @see com.cosylab.cdb.jdal.hibernate.plugin.HibernateWDALPlugin#loadPrologue(org.hibernate.Session, alma.acs.tmcdb.Configuration, java.util.Map)
	 */
	public void loadPrologue(Session session, Configuration config, Map<String, Object> rootMap) {
		// noop
	}

	public String[] getCreateTablesScriptList(String backend) {
		
		String ddlDir = System.getProperty("ACS.ddlpath");
		if (ddlDir == null)
			ddlDir = ".";
		
		if (backend.equals(DBUtil.ORACLE_BACKEND_NAME)) { 
			return new String[] {
				ddlDir + "/oracle/TMCDB_hwconfigmonitoring/CreateOracleTables.sql"
			};
		}
		else if (backend.equals(DBUtil.HSQLDB_BACKEND_NAME)) { 
			return new String[] {
				ddlDir + "/hsqldb/TMCDB_hwconfigmonitoring/CreateHsqldbTables.sql"
			};
	
		}
		else
			return null;
	}
}
