/**
 * 
 */
package alma.archive.tmcdb.monitor;

import alma.MonitorArchiver.BlobberOperations;
import alma.MonitorArchiver.CollectorListStatus;
import alma.acs.component.ComponentImplBase;
import alma.acs.component.ComponentLifecycleException;
import alma.acs.container.ContainerServices;

/**
 * @author apersson
 * 
 */
public class BlobberImpl extends ComponentImplBase implements BlobberOperations {

    protected BlobberWorker myWorker;

    protected Thread myWorkerThread;

    @Override
    public void cleanUp() {
        this.myWorker.terminate();
        if (this.myWorkerThread != null) {
            this.myWorkerThread.interrupt();
        }
    }

    @Override
    public void initialize(ContainerServices inContainerServices)
            throws ComponentLifecycleException {
        super.initialize(inContainerServices);

        initialize();
    }

    public void initialize() {
        this.myWorker = createWorker();
        startWorker(this.myWorker);
    }

    @Override
    public CollectorListStatus addCollector(String inComponentName) {
        return this.myWorker.addCollector(inComponentName);
    }

    @Override
    public CollectorListStatus containsCollector(String inComponentName) {
        return this.myWorker.containsCollector(inComponentName);
    }

    @Override
    public CollectorListStatus removeCollector(String inComponentName) {
        return this.myWorker.removeCollector(inComponentName);
    }

    protected BlobberWorker createWorker() {
        return new BlobberWorker(m_containerServices);
    }

    protected void startWorker(BlobberWorker inWorker) {
        this.myWorkerThread = m_containerServices.getThreadFactory().newThread(
                inWorker);
        this.myWorkerThread.start();
    }
}
