/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import org.jacorb.idl.IntType;
import org.jacorb.idl.TypeSpec;

class ShortType
extends IntType {
    public ShortType(int n) {
        super(n);
    }

    @Override
    public String typeName() {
        return "short";
    }

    @Override
    public String getJavaTypeName() {
        return "short";
    }

    @Override
    public String getIDLTypeName() {
        if (this.unsigned) {
            return "ushort";
        }
        return "short";
    }

    @Override
    public TypeSpec typeSpec() {
        return this;
    }

    @Override
    public boolean basic() {
        return true;
    }

    @Override
    public int getTCKind() {
        if (this.unsigned) {
            return 4;
        }
        return 2;
    }

    @Override
    public String toString() {
        return this.typeName();
    }

    @Override
    public String holderName() {
        return "org.omg.CORBA.ShortHolder";
    }

    @Override
    public String printReadExpression(String string) {
        if (this.unsigned) {
            return string + ".read_ushort()";
        }
        return string + ".read_short()";
    }

    @Override
    public String printReadStatement(String string, String string2) {
        if (this.unsigned) {
            return string + "=" + string2 + ".read_ushort();";
        }
        return string + "=" + string2 + ".read_short();";
    }

    @Override
    public String printWriteStatement(String string, String string2) {
        if (this.unsigned) {
            return string2 + ".write_ushort(" + string + ");";
        }
        return string2 + ".write_short(" + string + ");";
    }

    @Override
    public String printInsertExpression() {
        if (this.unsigned) {
            return "insert_ushort";
        }
        return "insert_short";
    }

    @Override
    public String printExtractExpression() {
        if (this.unsigned) {
            return "extract_ushort";
        }
        return "extract_short";
    }

    @Override
    public void printInsertIntoAny(PrintWriter printWriter, String string, String string2) {
        printWriter.println("\t\t" + string + "." + this.printInsertExpression() + "(" + string2 + ");");
    }

    @Override
    public void printExtractResult(PrintWriter printWriter, String string, String string2, String string3) {
        printWriter.println("\t\t" + string + " = " + string2 + "." + this.printExtractExpression() + "();");
    }
}

