/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.TypeSpec;

class OctetType
extends BaseType {
    public OctetType(int n) {
        super(n);
    }

    @Override
    public Object clone() {
        return new OctetType(OctetType.new_num());
    }

    @Override
    public String typeName() {
        return "byte";
    }

    @Override
    public String getJavaTypeName() {
        return "byte";
    }

    @Override
    public String getIDLTypeName() {
        return "octet";
    }

    @Override
    public TypeSpec typeSpec() {
        return this;
    }

    @Override
    public String toString() {
        return this.typeName();
    }

    @Override
    public boolean basic() {
        return true;
    }

    @Override
    public int getTCKind() {
        return 10;
    }

    @Override
    public void parse() {
    }

    @Override
    public String holderName() {
        return "org.omg.CORBA.ByteHolder";
    }

    @Override
    public String printReadExpression(String string) {
        return string + ".read_octet()";
    }

    @Override
    public String printWriteStatement(String string, String string2) {
        return string2 + ".write_octet(" + string + ");";
    }

    @Override
    public String printInsertExpression() {
        return "insert_octet";
    }

    @Override
    public String printExtractExpression() {
        return "extract_octet";
    }

    @Override
    public void printInsertIntoAny(PrintWriter printWriter, String string, String string2) {
        printWriter.println("\t" + string + "." + this.printInsertExpression() + "(" + string2 + ");");
    }

    @Override
    public void printExtractResult(PrintWriter printWriter, String string, String string2, String string3) {
        printWriter.println("\t\t" + string + " = " + string2 + "." + this.printExtractExpression() + "();");
    }
}

