/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.jacorb.idl.Declaration;
import org.jacorb.idl.Definitions;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.Scope;
import org.jacorb.idl.ScopeData;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;

public class Module
extends Declaration
implements Scope {
    public Definitions spec;
    private ScopeData scopeData;
    private String unreplacedName = null;

    public Module(int n) {
        super(n);
        this.pack_name = "";
    }

    @Override
    public void setScopeData(ScopeData scopeData) {
        this.scopeData = scopeData;
    }

    @Override
    public ScopeData getScopeData() {
        return this.scopeData;
    }

    @Override
    public void setPackage(String string) {
        if (this.unreplacedName == null) {
            this.unreplacedName = string;
        }
        string = parser.pack_replace(string);
        if (this.pack_name.length() > 0) {
            this.pack_name = string + "." + this.pack_name;
            this.spec.setPackage(string);
        } else {
            this.pack_name = string;
            if (lexer.needsJavaEscape(this)) {
                this.pack_name = "_" + string;
            }
            this.name = this.pack_name;
            this.spec.setPackage(this.pack_name);
        }
    }

    @Override
    String full_name() {
        return this.pack_name;
    }

    @Override
    public void set_included(boolean bl) {
        this.included = bl;
        this.spec.set_included(bl);
    }

    @Override
    public void setEnclosingSymbol(IdlSymbol idlSymbol) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != idlSymbol) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = idlSymbol;
        this.spec.setEnclosingSymbol(this);
    }

    @Override
    public void parse() {
        try {
            NameTable.define(this.full_name(), "module");
        }
        catch (NameAlreadyDefined nameAlreadyDefined) {
            parser.error("Module name " + this.full_name() + " already defined", this.token);
        }
        this.spec.parse();
    }

    @Override
    public void print(PrintWriter printWriter) {
        block5: {
            if (parser.generateIR) {
                try {
                    File file;
                    String string = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator);
                    File file2 = new File(string);
                    if (!file2.exists() && !file2.mkdirs()) {
                        parser.fatal_error("Unable to create " + string, null);
                    }
                    if (GlobalInputStream.isMoreRecentThan(file = new File(file2, "_" + this.name + "Module.java"))) {
                        PrintWriter printWriter2 = new PrintWriter(new FileWriter(file));
                        printWriter2.println("package " + this.pack_name + ";\n");
                        printWriter2.println("/** \n * IR module information, generated by the JacORB IDL compiler \n */");
                        printWriter2.println("public class _" + this.name + "Module {}");
                        printWriter2.close();
                    }
                }
                catch (IOException iOException) {
                    if (!this.logger.isWarnEnabled()) break block5;
                    this.logger.warn("Exception: ", (Throwable)iOException);
                }
            }
        }
        this.spec.print(printWriter);
    }

    public String originalModuleName() {
        return this.unreplacedName;
    }

    public Definitions getDefinitions() {
        return this.spec;
    }

    @Override
    public void accept(IDLTreeVisitor iDLTreeVisitor) {
        iDLTreeVisitor.visitModule(this);
    }
}

