/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import org.jacorb.idl.IntType;
import org.jacorb.idl.TypeSpec;

class LongType
extends IntType {
    public LongType(int n) {
        super(n);
    }

    @Override
    public Object clone() {
        return new LongType(LongType.new_num());
    }

    @Override
    public TypeSpec typeSpec() {
        return this;
    }

    @Override
    public String typeName() {
        return "int";
    }

    @Override
    public String getJavaTypeName() {
        return "int";
    }

    @Override
    public String getIDLTypeName() {
        if (this.unsigned) {
            return "ulong";
        }
        return "long";
    }

    @Override
    public boolean basic() {
        return true;
    }

    @Override
    public int getTCKind() {
        return this.unsigned ? 5 : 3;
    }

    @Override
    public String toString() {
        return this.typeName();
    }

    @Override
    public String holderName() {
        return "org.omg.CORBA.IntHolder";
    }

    @Override
    public String printReadExpression(String string) {
        if (this.unsigned) {
            return string + ".read_ulong()";
        }
        return string + ".read_long()";
    }

    @Override
    public String printWriteStatement(String string, String string2) {
        if (this.unsigned) {
            return string2 + ".write_ulong(" + string + ");";
        }
        return string2 + ".write_long(" + string + ");";
    }

    @Override
    public String printInsertExpression() {
        if (this.unsigned) {
            return "insert_ulong";
        }
        return "insert_long";
    }

    @Override
    public String printExtractExpression() {
        if (this.unsigned) {
            return "extract_ulong";
        }
        return "extract_long";
    }

    @Override
    public void printInsertIntoAny(PrintWriter printWriter, String string, String string2) {
        printWriter.println("\t\t" + string + "." + this.printInsertExpression() + "(" + string2 + ");");
    }

    @Override
    public void printExtractResult(PrintWriter printWriter, String string, String string2, String string3) {
        printWriter.println("\t\t" + string + " = " + string2 + "." + this.printExtractExpression() + "();");
    }
}

