/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import org.jacorb.idl.IntType;
import org.jacorb.idl.TypeSpec;

class LongLongType
extends IntType {
    public LongLongType(int n) {
        super(n);
    }

    @Override
    public Object clone() {
        return new LongLongType(LongLongType.new_num());
    }

    @Override
    public TypeSpec typeSpec() {
        return this;
    }

    @Override
    public String typeName() {
        return "long";
    }

    @Override
    public String getJavaTypeName() {
        return this.typeName();
    }

    @Override
    public String getIDLTypeName() {
        if (this.unsigned) {
            return "ulonglong";
        }
        return "longlong";
    }

    @Override
    public boolean basic() {
        return true;
    }

    @Override
    public int getTCKind() {
        if (this.unsigned) {
            return 24;
        }
        return 23;
    }

    @Override
    public String toString() {
        return this.typeName();
    }

    @Override
    public String holderName() {
        return "org.omg.CORBA.LongHolder";
    }

    @Override
    public String printReadExpression(String string) {
        if (this.unsigned) {
            return string + ".read_ulonglong()";
        }
        return string + ".read_longlong()";
    }

    @Override
    public String printReadStatement(String string, String string2) {
        if (this.unsigned) {
            return string + "=" + string2 + ".read_ulonglong();";
        }
        return string + "=" + string2 + ".read_longlong();";
    }

    @Override
    public String printWriteStatement(String string, String string2) {
        if (this.unsigned) {
            return string2 + ".write_ulonglong(" + string + ");";
        }
        return string2 + ".write_longlong(" + string + ");";
    }

    @Override
    public String printInsertExpression() {
        if (this.unsigned) {
            return "insert_ulonglong";
        }
        return "insert_longlong";
    }

    @Override
    public String printExtractExpression() {
        if (this.unsigned) {
            return "extract_ulonglong";
        }
        return "extract_longlong";
    }

    @Override
    public void printInsertIntoAny(PrintWriter printWriter, String string, String string2) {
        printWriter.println("\t\t" + string + "." + this.printInsertExpression() + "(" + string2 + ");");
    }

    @Override
    public void printExtractResult(PrintWriter printWriter, String string, String string2, String string3) {
        printWriter.println("\t\t" + string + " = " + string2 + "." + this.printExtractExpression() + "();");
    }
}

