/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import org.jacorb.idl.FloatPtType;
import org.jacorb.idl.TypeSpec;

class DoubleType
extends FloatPtType {
    private boolean isLongDouble = false;

    public DoubleType(int n) {
        super(n);
    }

    @Override
    public String typeName() {
        return "double";
    }

    public void setLongDouble() {
        this.isLongDouble = true;
    }

    @Override
    public TypeSpec typeSpec() {
        return this;
    }

    @Override
    public boolean basic() {
        return true;
    }

    @Override
    public int getTCKind() {
        return 7;
    }

    @Override
    public String toString() {
        return this.typeName();
    }

    @Override
    public String holderName() {
        return "org.omg.CORBA.DoubleHolder";
    }

    @Override
    public String printReadExpression(String string) {
        return string + ".read_double()";
    }

    @Override
    public String printWriteStatement(String string, String string2) {
        return string2 + ".write_double(" + string + ");";
    }

    @Override
    public String printInsertExpression() {
        return "insert_double";
    }

    @Override
    public String printExtractExpression() {
        return "extract_double";
    }

    @Override
    public void printInsertIntoAny(PrintWriter printWriter, String string, String string2) {
        printWriter.println("\t\t" + string + "." + this.printInsertExpression() + "(" + string2 + ");");
    }

    @Override
    public void printExtractResult(PrintWriter printWriter, String string, String string2, String string3) {
        printWriter.println("\t\t" + string + " = " + string2 + "." + this.printExtractExpression() + "();");
    }
}

