/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.SwitchTypeSpec;
import org.jacorb.idl.TypeSpec;

class BooleanType
extends BaseType
implements SwitchTypeSpec {
    public BooleanType(int n) {
        super(n);
    }

    @Override
    public String typeName() {
        return "boolean";
    }

    @Override
    public TypeSpec typeSpec() {
        return this;
    }

    @Override
    public boolean basic() {
        return true;
    }

    @Override
    public int getTCKind() {
        return 8;
    }

    @Override
    public String toString() {
        return this.typeName();
    }

    @Override
    public void parse() {
    }

    @Override
    public String holderName() {
        return "org.omg.CORBA.BooleanHolder";
    }

    @Override
    public String printReadExpression(String string) {
        return string + ".read_boolean()";
    }

    @Override
    public String printWriteStatement(String string, String string2) {
        return string2 + ".write_boolean(" + string + ");";
    }

    @Override
    public String printInsertExpression() {
        return "insert_boolean";
    }

    @Override
    public String printExtractExpression() {
        return "extract_boolean";
    }

    @Override
    public boolean isSwitchable() {
        return true;
    }

    @Override
    public void printInsertIntoAny(PrintWriter printWriter, String string, String string2) {
        printWriter.println("\t\t" + string + "." + this.printInsertExpression() + "(" + string2 + ");");
    }

    @Override
    public void printExtractResult(PrintWriter printWriter, String string, String string2, String string3) {
        printWriter.println("\t\t" + string + " = " + string2 + "." + this.printExtractExpression() + "();");
    }
}

