/*
 * Decompiled with CFR 0.152.
 */
package cern.cmw.mom.pubsub.impl;

import cern.cmw.mom.pubsub.ExceptionListener;
import cern.cmw.mom.pubsub.MOMException;
import cern.cmw.mom.pubsub.Publisher;
import cern.cmw.mom.pubsub.impl.ConnectionException;
import cern.cmw.mom.pubsub.impl.JMSTopicConnection;
import cern.cmw.mom.pubsub.impl.JMSTopicConnectionFactory;
import cern.cmw.mom.util.MomConfig;
import cern.cmw.mom.util.TopicAdminHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.NamingException;
import org.apache.log4j.Category;

public class DefaultPublisherImpl
implements Publisher,
javax.jms.ExceptionListener {
    static Category cat = Category.getInstance((String)DefaultPublisherImpl.class.getName());
    private Boolean loadBalancing;
    private Boolean selectorAtBroker;
    private Boolean sequential;
    private ExceptionListener listener = null;
    private JMSTopicConnection connection = null;
    private Map topicDirectory = null;
    private Properties momProperties = null;
    private String brokerList;
    private String password;
    private String username;
    private TopicPublisher publisher = null;
    private TopicSession session = null;
    private boolean closed = true;
    private int defaultPersistance;
    private int defaultPriority;
    private long defaultTimeToLive;

    public DefaultPublisherImpl() throws MOMException {
        this.username = null;
        this.password = null;
        this.brokerList = null;
        this.loadBalancing = null;
        this.sequential = null;
        this.selectorAtBroker = null;
        this.open();
    }

    public DefaultPublisherImpl(String string, String string2, String string3, Boolean bl, Boolean bl2, Boolean bl3) throws MOMException {
        this.username = string;
        this.password = string2;
        this.brokerList = string3;
        this.loadBalancing = bl;
        this.sequential = bl2;
        this.selectorAtBroker = bl3;
        this.open();
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.listener = exceptionListener;
    }

    @Override
    public void close() {
        cat.debug((Object)"close()");
        if (this.closed) {
            return;
        }
        try {
            if (this.publisher != null) {
                this.publisher.close();
                this.publisher = null;
            }
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
            if (this.connection != null) {
                try {
                    this.connection.stop();
                }
                catch (ConnectionException connectionException) {
                    connectionException.printStackTrace();
                }
                this.connection.close();
                this.connection = null;
            }
            if (this.topicDirectory != null) {
                this.topicDirectory.clear();
                this.topicDirectory = null;
            }
            this.closed = true;
        }
        catch (JMSException jMSException) {
            cat.error((Object)("JMSException raised closing a Publisher : " + jMSException.getMessage()));
        }
    }

    @Override
    public BytesMessage createBytesMessage() throws JMSException {
        if (this.closed) {
            throw new JMSException("Publisher object has been closed");
        }
        BytesMessage bytesMessage = null;
        bytesMessage = this.session.createBytesMessage();
        return bytesMessage;
    }

    @Override
    public MapMessage createMapMessage() throws JMSException {
        if (this.closed) {
            throw new JMSException("Publisher object has been closed");
        }
        MapMessage mapMessage = null;
        mapMessage = this.session.createMapMessage();
        return mapMessage;
    }

    @Override
    public Message createMessage() throws JMSException {
        if (this.closed) {
            throw new JMSException("Publisher object has been closed");
        }
        Message message = null;
        message = this.session.createMessage();
        return message;
    }

    @Override
    public ObjectMessage createObjectMessage() throws JMSException {
        if (this.closed) {
            throw new JMSException("Publisher object has been closed");
        }
        ObjectMessage objectMessage = null;
        objectMessage = this.session.createObjectMessage();
        return objectMessage;
    }

    @Override
    public StreamMessage createStreamMessage() throws JMSException {
        if (this.closed) {
            throw new JMSException("Publisher object has been closed");
        }
        StreamMessage streamMessage = null;
        streamMessage = this.session.createStreamMessage();
        return streamMessage;
    }

    @Override
    public TextMessage createTextMessage() throws JMSException {
        if (this.closed) {
            throw new JMSException("Publisher object has been closed");
        }
        TextMessage textMessage = null;
        textMessage = this.session.createTextMessage();
        return textMessage;
    }

    public void onException(JMSException jMSException) {
        cat.warn((Object)"onException()");
    }

    public void open() throws MOMException {
        cat.debug((Object)"open()");
        this.initialize(false);
    }

    @Override
    public void publish(String string, Message message) throws JMSException, NamingException {
        this.publish(string, message, this.defaultPersistance, this.defaultPriority, this.defaultTimeToLive);
    }

    @Override
    public void publish(String string, Message message, int n, int n2, long l) throws JMSException, NamingException {
        cat.debug((Object)("publish(" + string + ", " + message + ")"));
        if (this.closed) {
            throw new JMSException("Publisher object has been closed");
        }
        Topic topic = this.createTopic(string);
        try {
            this.publisher.publish(topic, message, n, n2, l);
        }
        catch (JMSSecurityException jMSSecurityException) {
            cat.error((Object)"JMSSecurityException caught");
            throw new NamingException(jMSSecurityException.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        cat.debug((Object)"finalize()");
        this.close();
        super.finalize();
    }

    private Topic createTopic(String string) throws JMSException, NamingException {
        cat.debug((Object)("createTopic(" + string + ")"));
        Topic topic = null;
        if (TopicAdminHelper.validateTopic(string, this.connection.getUsername(), 0)) {
            topic = (Topic)this.topicDirectory.get(string);
            if (topic == null) {
                topic = this.session.createTopic(string);
                this.topicDirectory.put(string, topic);
            }
        } else {
            throw new NamingException("[" + string + "] is not a valid topic name");
        }
        return topic;
    }

    private void initialize(boolean bl) throws MOMException {
        this.momProperties = MomConfig.getProperties(this.getClass().getClassLoader());
        this.defaultPersistance = this.momProperties.getProperty("cmw.mom.persistance").equals("true") ? 2 : 1;
        this.defaultPriority = Integer.parseInt(this.momProperties.getProperty("cmw.mom.priority"));
        this.defaultTimeToLive = Long.parseLong(this.momProperties.getProperty("cmw.mom.timetolive"));
        this.topicDirectory = new HashMap();
        try {
            this.connection = JMSTopicConnectionFactory.createJMSTopicConnection(this.username, this.password, this.brokerList, this.loadBalancing, this.sequential, this.selectorAtBroker);
            this.connection.connect(bl);
            this.connection.setExceptionListener(this);
            this.session = this.connection.createTopicSession();
            this.connection.start();
            this.publisher = this.session.createPublisher(null);
            this.closed = false;
        }
        catch (ConnectionException connectionException) {
            System.out.println("Exception caught: " + connectionException.getMessage());
            connectionException.printStackTrace(System.err);
            throw new MOMException("Unable to estabilish a connection, cause is : " + connectionException.getMessage());
        }
        catch (JMSException jMSException) {
            System.out.println("Exception caught: " + jMSException.getMessage());
            jMSException.printStackTrace(System.err);
            throw new MOMException(jMSException.getMessage());
        }
    }
}

