/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.monitorstream;

import alma.acs.component.ComponentImplBase;
import alma.acs.component.ComponentLifecycleException;
import alma.acs.container.ContainerServices;
import alma.acs.container.ContainerServicesBase;
import alma.acs.exceptions.AcsJException;
import alma.acs.nc.SimpleSupplier;
import alma.archive.database.helpers.DBConfiguration;
import alma.archive.database.interfaces.DBCursor;
import alma.archive.database.interfaces.IdentifierManager;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.access.PermissionDeniedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.UnknownSchemaException;
import alma.archive.exceptions.user.UserDoesNotExistException;
import alma.archive.wrappers.ArchiveTimeStamp;
import alma.archive.wrappers.Permissions;
import alma.archive.wrappers.ResultStruct;
import alma.monitorstream.MonitorStreamListenerOperations;
import alma.monitorstream.MonitorStreamListenerPackage.MonitorStreamStoreException;
import alma.monitorstream.MonitordataStoreNotificationEvent;
import alma.monitorstream.resultType;
import alma.ngas.client.JClient;
import alma.ngas.client.Status;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.omg.CORBA.portable.IDLEntity;

public class MonitorStreamStore
extends ComponentImplBase
implements MonitorStreamListenerOperations {
    long TIMEOUT = 30000L;
    protected boolean useMultiThreads = false;
    protected boolean useContinuous = false;
    protected boolean m_listenerClosed = false;
    protected boolean storeInNGAS = false;
    protected boolean initialized = false;
    protected static String NGAMShost = "almadev2";
    protected static int NGAMSport = 7777;
    JClient ngasJClient;
    ServerSocket m_serverSocket;
    protected String m_hostAndPort = "Not initialized";
    protected Integer m_listening;
    protected String synchronizer = "";
    protected InternalIF m_operArchiveComp;
    protected IdentifierManager m_identArchiveComp;
    protected DBConfiguration config;
    protected static final String m_testDir = System.getProperty("ACS.tmp");
    protected String contentType = "multialma/related";
    protected static URI m_schemaURI;
    protected static String m_schemaName;
    protected static final String m_userName = "testUser";
    protected String m_componentName;
    protected Logger m_logger;
    SimpleSupplier monitorNotifyChannel;

    public void close() throws MonitorStreamStoreException {
        if (this.monitorNotifyChannel != null) {
            this.monitorNotifyChannel.disconnect();
            this.monitorNotifyChannel = null;
        }
    }

    public void init() throws MonitorStreamStoreException {
        if (this.m_operArchiveComp == null) {
            try {
                this.m_operArchiveComp = InternalIFFactory.getInternalIF((Logger)this.m_logger);
            }
            catch (DatabaseException databaseException) {
                throw new MonitorStreamStoreException(databaseException.toString());
            }
            catch (ModuleCriticalException moduleCriticalException) {
                throw new MonitorStreamStoreException(moduleCriticalException.getCause().toString());
            }
        }
        try {
            this.config = DBConfiguration.instance((Logger)this.m_logger);
        }
        catch (DatabaseException databaseException) {
            throw new MonitorStreamStoreException(databaseException.toString());
        }
        if ("true".equalsIgnoreCase(this.config.get("archive.ngast.storeInNgast"))) {
            this.storeInNGAS = true;
        }
        if (this.config.get("archive.ngast.server") != null) {
            NGAMShost = this.config.get("archive.ngast.server");
        }
        if (this.config.get("archive.ngast.port") != null) {
            NGAMSport = Integer.parseInt(this.config.get("archive.ngast.port"));
        }
        if (this.config.get("archive.monitor.schema") != null) {
            m_schemaName = this.config.get("archive.monitor.schema");
        }
        this.m_logger.info("Using schema name for monitor data: " + m_schemaName);
        if (this.storeInNGAS) {
            this.m_logger.info("NGAMS mode: connecting to " + NGAMShost + ":" + NGAMSport);
            Vector<InetSocketAddress> vector = new Vector<InetSocketAddress>();
            vector.add(new InetSocketAddress(NGAMShost, NGAMSport));
            this.ngasJClient = new JClient(vector, 0, "", null, this.m_logger);
        } else {
            this.m_logger.info("Local mode: Storing and retrieving files using local disk: " + this.uid2filename(""));
        }
        try {
            m_schemaURI = this.ensureSchemaExists(m_schemaName);
        }
        catch (Exception exception) {
            this.m_logger.severe("Serious problems with schema for monitor metadata.");
            throw new MonitorStreamStoreException(exception.toString());
        }
        this.initialized = true;
    }

    public String startListener() throws MonitorStreamStoreException {
        this.m_listenerClosed = false;
        if (!this.initialized) {
            this.init();
        }
        if (this.m_serverSocket != null) {
            this.m_logger.severe("Monitor listener already listening on port " + this.m_serverSocket.getLocalPort() + ". Operations may be heavily disturbed!");
        }
        try {
            this.m_serverSocket = new ServerSocket(0);
        }
        catch (IOException iOException) {
            throw new MonitorStreamStoreException(iOException.toString());
        }
        this.m_listening = new Integer(0);
        if (this.useMultiThreads) {
            new MultiStreamListener().start();
            this.m_logger.info("Monitor listener up and waiting... Using multiple threads");
        } else if (this.useContinuous) {
            new ContinuousSingleStreamListener().start();
            this.m_logger.info("Monitor listener up and waiting... Using continuous single thread");
        } else {
            new SingleStreamListener().start();
            this.m_logger.info("Monitor listener up and waiting... Using single thread");
        }
        try {
            this.m_hostAndPort = InetAddress.getLocalHost().getHostAddress() + ":" + this.m_serverSocket.getLocalPort();
        }
        catch (UnknownHostException unknownHostException) {
            this.m_logger.severe("Could not resolve local host name!");
            throw new MonitorStreamStoreException("Couldn't resolve local host name!");
        }
        return this.m_hostAndPort;
    }

    public void stopListener(String string) throws MonitorStreamStoreException {
        if (this.m_serverSocket != null && string.equals(this.m_hostAndPort)) {
            if (this.useMultiThreads) {
                this.waitUntilFinished();
            }
            this.m_listenerClosed = true;
            try {
                this.socketsClose();
            }
            catch (IOException iOException) {
                throw new MonitorStreamStoreException(iOException.toString());
            }
        } else {
            throw new MonitorStreamStoreException("Unregistered address or port");
        }
        this.m_logger.info("Monitor listener stopped.");
        if (this.monitorNotifyChannel != null) {
            this.monitorNotifyChannel.disconnect();
            this.monitorNotifyChannel = null;
        }
    }

    public byte[][] getMonitorData(String string, String string2) throws MonitorStreamStoreException {
        Vector vector = this.internalGetMonitorData(string, string2);
        byte[][] byArrayArray = new byte[vector.size()][];
        int n = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            byte[] byArray;
            try {
                Closeable closeable;
                if (this.storeInNGAS) {
                    closeable = new ByteArrayOutputStream();
                    Status status = this.ngasJClient.retrieveStream(((String)iterator.next()).substring(6), (OutputStream)closeable);
                    if (!status.getOK()) {
                        this.m_logger.info(status.getRequestStatus());
                        this.m_logger.fine(status.getMessage());
                    }
                    byArray = ((ByteArrayOutputStream)closeable).toByteArray();
                } else {
                    closeable = new FileInputStream(this.uid2filename((String)iterator.next()));
                    byArray = new byte[((FileInputStream)closeable).available()];
                    ((FileInputStream)closeable).read(byArray);
                }
            }
            catch (Exception exception) {
                throw new MonitorStreamStoreException(exception.toString());
            }
            byArrayArray[n] = byArray;
            ++n;
        }
        return byArrayArray;
    }

    public String[] getMonUIDs(String string, String string2, String string3) throws MonitorStreamStoreException {
        if (!this.initialized) {
            this.init();
        }
        Vector vector = this.internalGetMonitorData(string, string2, string3);
        return vector.toArray(new String[0]);
    }

    public byte[][] getMonData(String string, String string2, String string3) throws MonitorStreamStoreException {
        if (!this.initialized) {
            this.init();
        }
        Vector vector = this.internalGetMonitorData(string, string2, string3);
        this.m_logger.finest("Found " + vector.size() + " matching documents for monitor data query. Now retrieving full docs.");
        if (vector.size() > 30) {
            this.m_logger.warning("Too many documents returned; Only first 30 are handed over! Consider using a smaller time interval.");
        }
        int n = vector.size() > 30 ? 30 : vector.size();
        byte[][] byArrayArray = new byte[n][];
        int n2 = 0;
        int n3 = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext() && n3 < 30) {
            byte[] byArray;
            ++n3;
            try {
                Closeable closeable;
                if (this.storeInNGAS) {
                    closeable = new ByteArrayOutputStream();
                    Status status = this.ngasJClient.retrieveStream(((String)iterator.next()).substring(6), (OutputStream)closeable);
                    if (!status.getOK()) {
                        this.m_logger.info(status.getRequestStatus());
                        this.m_logger.fine(status.getMessage());
                    }
                    byArray = ((ByteArrayOutputStream)closeable).toByteArray();
                } else {
                    closeable = new FileInputStream(this.uid2filename((String)iterator.next()));
                    byArray = new byte[((FileInputStream)closeable).available()];
                    ((FileInputStream)closeable).read(byArray);
                }
            }
            catch (Exception exception) {
                throw new MonitorStreamStoreException(exception.toString());
            }
            byArrayArray[n2] = byArray;
            ++n2;
        }
        return byArrayArray;
    }

    protected Vector internalGetMonitorData(String string, String string2, String string3) throws MonitorStreamStoreException {
        DBCursor dBCursor;
        Vector<String> vector = new Vector<String>();
        String string4 = "/VOTABLE/RESOURCE[@ID=\"" + string3 + "\" or @name=\"" + string3 + "\"]/../DEFINITIONS/PARAM[@ID=\"timeFrom\"]";
        this.m_logger.finest("Constructed XPath query: " + string4 + " for schema " + m_schemaName);
        final class VOTableTimeComparator
        implements Comparator {
            VOTableTimeComparator() {
            }

            public int compare(Object object, Object object2) {
                ResultStruct resultStruct = (ResultStruct)object;
                ResultStruct resultStruct2 = (ResultStruct)object2;
                if (resultStruct.getXml().equals(resultStruct2.getXml())) {
                    return resultStruct.getUri().toString().compareTo(resultStruct2.getUri().toString());
                }
                return resultStruct.getXml().compareTo(resultStruct2.getXml());
            }
        }
        VOTableTimeComparator vOTableTimeComparator = new VOTableTimeComparator();
        TreeSet<ResultStruct> treeSet = new TreeSet<ResultStruct>(vOTableTimeComparator);
        TreeSet<Object> treeSet2 = new TreeSet<Object>(vOTableTimeComparator);
        try {
            ResultStruct resultStruct;
            ResultStruct resultStruct2;
            dBCursor = this.m_operArchiveComp.query(string4, m_schemaName, new HashMap(), false, m_userName);
            while (dBCursor.hasNext()) {
                resultStruct2 = dBCursor.next();
                resultStruct = new ResultStruct(resultStruct2.getUri(), this.getAttVal(resultStruct2.getXml()));
                if (resultStruct.getXml() == null) continue;
                treeSet.add(resultStruct);
            }
            string4 = "/VOTABLE/RESOURCE[@ID=\"" + string3 + "\" or @name=\"" + string3 + "\"]/../DEFINITIONS/PARAM[@ID=\"timeTo\"]";
            this.m_logger.finest("Constructed XPath query: " + string4 + " for schema " + m_schemaName);
            dBCursor = this.m_operArchiveComp.query(string4, m_schemaName, new HashMap(), false, m_userName);
            while (dBCursor.hasNext()) {
                resultStruct2 = dBCursor.next();
                resultStruct = new ResultStruct(resultStruct2.getUri(), this.getAttVal(resultStruct2.getXml()));
                if (resultStruct.getXml() == null) continue;
                treeSet2.add(resultStruct);
            }
        }
        catch (ArchiveException archiveException) {
            throw new MonitorStreamStoreException(archiveException.toString());
        }
        catch (ModuleCriticalException moduleCriticalException) {
            throw new MonitorStreamStoreException(moduleCriticalException.getCause().toString());
        }
        dBCursor = null;
        ResultStruct resultStruct = null;
        try {
            dBCursor = new ResultStruct(new URI("uid"), string);
            resultStruct = new ResultStruct(new URI("uie"), string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        SortedSet<Object> sortedSet = treeSet.headSet(resultStruct);
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            ResultStruct resultStruct3 = (ResultStruct)iterator.next();
            Iterator iterator2 = treeSet2.tailSet(vOTableTimeComparator.compare(resultStruct3, dBCursor) < 0 ? dBCursor : resultStruct3).iterator();
            while (!bl && iterator2.hasNext()) {
                ResultStruct resultStruct4 = (ResultStruct)iterator2.next();
                if (!resultStruct3.getUri().equals(resultStruct4.getUri())) continue;
                vector.add(resultStruct3.getUri().toString());
                bl = true;
            }
        }
        return vector;
    }

    protected Vector internalGetMonitorData(String string, String string2) throws MonitorStreamStoreException {
        DBCursor dBCursor;
        Vector<String> vector = new Vector<String>();
        String string3 = "/VOTABLE/RESOURCE/PARAM[@name=\"timeFrom\"]";
        final class VOTableTimeComparator
        implements Comparator {
            VOTableTimeComparator() {
            }

            public int compare(Object object, Object object2) {
                ResultStruct resultStruct = (ResultStruct)object;
                ResultStruct resultStruct2 = (ResultStruct)object2;
                if (resultStruct.getXml().equals(resultStruct2.getXml())) {
                    return resultStruct.getUri().toString().compareTo(resultStruct2.getUri().toString());
                }
                return resultStruct.getXml().compareTo(resultStruct2.getXml());
            }
        }
        VOTableTimeComparator vOTableTimeComparator = new VOTableTimeComparator();
        TreeSet<ResultStruct> treeSet = new TreeSet<ResultStruct>(vOTableTimeComparator);
        TreeSet<Object> treeSet2 = new TreeSet<Object>(vOTableTimeComparator);
        try {
            ResultStruct resultStruct;
            ResultStruct resultStruct2;
            dBCursor = this.m_operArchiveComp.query(string3, m_schemaName, new HashMap(), false, m_userName);
            while (dBCursor.hasNext()) {
                resultStruct2 = dBCursor.next();
                resultStruct = new ResultStruct(resultStruct2.getUri(), this.getAttVal(resultStruct2.getXml()));
                if (resultStruct.getXml() == null) continue;
                treeSet.add(resultStruct);
            }
            string3 = "/VOTABLE/RESOURCE/PARAM[@name=\"timeTo\"]";
            dBCursor = this.m_operArchiveComp.query(string3, m_schemaName, new HashMap(), false, m_userName);
            while (dBCursor.hasNext()) {
                resultStruct2 = dBCursor.next();
                resultStruct = new ResultStruct(resultStruct2.getUri(), this.getAttVal(resultStruct2.getXml()));
                if (resultStruct.getXml() == null) continue;
                treeSet2.add(resultStruct);
            }
        }
        catch (ArchiveException archiveException) {
            throw new MonitorStreamStoreException(archiveException.toString());
        }
        catch (ModuleCriticalException moduleCriticalException) {
            throw new MonitorStreamStoreException(moduleCriticalException.getCause().toString());
        }
        dBCursor = null;
        ResultStruct resultStruct = null;
        try {
            dBCursor = new ResultStruct(new URI("uid"), string);
            resultStruct = new ResultStruct(new URI("uie"), string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        SortedSet<Object> sortedSet = treeSet.headSet(resultStruct);
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            ResultStruct resultStruct3 = (ResultStruct)iterator.next();
            Iterator iterator2 = treeSet2.tailSet(vOTableTimeComparator.compare(resultStruct3, dBCursor) < 0 ? dBCursor : resultStruct3).iterator();
            while (!bl && iterator2.hasNext()) {
                ResultStruct resultStruct4 = (ResultStruct)iterator2.next();
                if (!resultStruct3.getUri().equals(resultStruct4.getUri())) continue;
                vector.add(resultStruct3.getUri().toString());
                bl = true;
            }
        }
        return vector;
    }

    protected void processStream(InputStream inputStream) {
        Object object;
        String string;
        MimeMultipart mimeMultipart;
        MimeBodyPart mimeBodyPart;
        ArchiveTimeStamp archiveTimeStamp = new ArchiveTimeStamp();
        try {
            mimeBodyPart = new MimeBodyPart(inputStream);
            mimeMultipart = (MimeMultipart)mimeBodyPart.getContent();
        }
        catch (MessagingException messagingException) {
            this.m_logger.warning(messagingException.toString());
            try {
                this.monitorNotifyChannel.publishEvent((IDLEntity)new MonitordataStoreNotificationEvent(archiveTimeStamp.toISOString(), "", "", "", resultType.FAILURE_COMMUNICATION));
            }
            catch (AcsJException acsJException) {
                this.m_logger.warning("Could not publish on NC monitorstore");
            }
            throw new RuntimeException(messagingException);
        }
        catch (IOException iOException) {
            this.m_logger.warning(iOException.toString());
            try {
                this.monitorNotifyChannel.publishEvent((IDLEntity)new MonitordataStoreNotificationEvent(archiveTimeStamp.toISOString(), "", "", "", resultType.FAILURE_COMMUNICATION));
            }
            catch (AcsJException acsJException) {
                this.m_logger.warning("Could not publish on NC monitorstore");
            }
            throw new RuntimeException(iOException);
        }
        String string2 = null;
        try {
            string2 = mimeBodyPart.getHeader("alma-uid")[0];
        }
        catch (MessagingException messagingException) {
            this.m_logger.warning("Missing uid in incoming stream");
            try {
                this.monitorNotifyChannel.publishEvent((IDLEntity)new MonitordataStoreNotificationEvent(archiveTimeStamp.toISOString(), "", "", "", resultType.FAILURE_INVALID_FORMAT));
            }
            catch (AcsJException acsJException) {
                this.m_logger.warning("Could not publish on NC monitorstore");
            }
            throw new RuntimeException(messagingException);
        }
        if (this.storeInNGAS) {
            string = string2.substring(6);
            this.m_logger.info("Storing incoming stream in NGAS under " + string);
            try {
                object = new PipedOutputStream();
                PipedInputStream pipedInputStream = new PipedInputStream((PipedOutputStream)object);
                new NGASWriter(pipedInputStream, string).start();
                mimeBodyPart.writeTo((OutputStream)object);
                ((PipedOutputStream)object).close();
            }
            catch (MessagingException messagingException) {
                try {
                    this.m_logger.warning("Could not handle incoming stream correctly");
                    this.m_logger.warning(messagingException.toString());
                    this.monitorNotifyChannel.publishEvent((IDLEntity)new MonitordataStoreNotificationEvent(archiveTimeStamp.toISOString(), string2, "", "", resultType.FAILURE_COMMUNICATION));
                }
                catch (AcsJException acsJException) {
                    this.m_logger.warning("Could not publish on NC monitorstore.");
                }
                throw new RuntimeException(messagingException);
            }
            catch (IOException iOException) {
                this.m_logger.warning("Problems during stream processing (connecting incoming MIME to outgoing stream to NGAS).");
                this.m_logger.warning(iOException.toString());
                try {
                    this.monitorNotifyChannel.publishEvent((IDLEntity)new MonitordataStoreNotificationEvent(archiveTimeStamp.toISOString(), string2, "", "", resultType.FAILURE_COMMUNICATION));
                }
                catch (AcsJException acsJException) {
                    this.m_logger.warning("Could not publish on NC monitorstore.");
                }
                throw new RuntimeException(iOException);
            }
        }
        string = string2.replace('/', '_');
        object = this.config.get("archive.ngast.testDir");
        if (object == null) {
            object = m_testDir;
            this.m_logger.info("Using default tempDir for monitor data");
        }
        this.m_logger.info("Storing incoming stream under " + (String)object + "/" + string);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream((String)object + "/" + string);
            mimeBodyPart.writeTo((OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_logger.severe("Could not open/write to/close file " + (String)object + "/" + string);
            this.m_logger.warning(fileNotFoundException.toString());
            try {
                this.monitorNotifyChannel.publishEvent((IDLEntity)new MonitordataStoreNotificationEvent(archiveTimeStamp.toISOString(), string2, "", "", resultType.FAILURE_INTERNAL));
            }
            catch (AcsJException acsJException) {
                this.m_logger.warning("Could not publish on NC monitorstore");
            }
            throw new RuntimeException(fileNotFoundException);
        }
        catch (IOException iOException) {
            this.m_logger.severe("IO exception when handling file " + (String)object + "/" + string);
            this.m_logger.warning(iOException.toString());
            try {
                this.monitorNotifyChannel.publishEvent((IDLEntity)new MonitordataStoreNotificationEvent(archiveTimeStamp.toISOString(), string2, "", "", resultType.FAILURE_INTERNAL));
            }
            catch (AcsJException acsJException) {
                this.m_logger.warning("Could not publish on NC monitorstore");
            }
            throw new RuntimeException(iOException);
        }
        catch (MessagingException messagingException) {
            this.m_logger.warning("Could not handle incoming stream correctly");
            this.m_logger.warning(messagingException.toString());
            try {
                this.monitorNotifyChannel.publishEvent((IDLEntity)new MonitordataStoreNotificationEvent(archiveTimeStamp.toISOString(), string2, "", "", resultType.FAILURE_COMMUNICATION));
            }
            catch (AcsJException acsJException) {
                this.m_logger.warning("Could not publish on NC monitorstore");
            }
            throw new RuntimeException(messagingException);
        }
        try {
            string = (String)mimeMultipart.getBodyPart(0).getContent();
        }
        catch (IOException iOException) {
            this.m_logger.warning("IO exception when handling incoming stream");
            this.m_logger.warning(iOException.toString());
            try {
                this.monitorNotifyChannel.publishEvent((IDLEntity)new MonitordataStoreNotificationEvent(archiveTimeStamp.toISOString(), string2, "", "", resultType.FAILURE_COMMUNICATION));
            }
            catch (AcsJException acsJException) {
                this.m_logger.warning("Could not publish on NC monitorstore");
            }
            throw new RuntimeException(iOException);
        }
        catch (MessagingException messagingException) {
            this.m_logger.warning("Could not handle incoming stream");
            this.m_logger.warning(messagingException.toString());
            try {
                this.monitorNotifyChannel.publishEvent((IDLEntity)new MonitordataStoreNotificationEvent(archiveTimeStamp.toISOString(), string2, "", "", resultType.FAILURE_COMMUNICATION));
            }
            catch (AcsJException acsJException) {
                this.m_logger.warning("Could not publish on NC monitorstore");
            }
            throw new RuntimeException(messagingException);
        }
        try {
            this.m_operArchiveComp.store(new URI(string2), string, m_schemaURI, m_schemaName, m_userName, new Permissions(), m_userName, true);
        }
        catch (Exception exception) {
            this.m_logger.severe("Could not store document in internal IF, uid: " + string2);
            this.m_logger.warning(exception.toString());
            try {
                this.monitorNotifyChannel.publishEvent((IDLEntity)new MonitordataStoreNotificationEvent(archiveTimeStamp.toISOString(), string2, "", "", resultType.FAILURE_INTERNAL));
            }
            catch (AcsJException acsJException) {
                this.m_logger.warning("Could not publish on NC monitorstore");
            }
            throw new RuntimeException(exception);
        }
        object = new MonitordataStoreNotificationEvent(archiveTimeStamp.toISOString(), string2, "", "", resultType.SUCCESS);
        try {
            this.monitorNotifyChannel.publishEvent((IDLEntity)object);
        }
        catch (AcsJException acsJException) {
            this.m_logger.warning("Could not publish on NC monitorstore");
        }
        this.m_logger.finer("Monitorstream processing completed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitUntilFinished() {
        this.m_logger.info("Waiting for shutdown of monitorstore....");
        while (this.m_listening > 0) {
            this.m_logger.fine("Living monitorstore threads: " + this.m_listening);
            String string = this.synchronizer;
            synchronized (string) {
                try {
                    this.synchronizer.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.m_logger.warning("Thread waiting for communication end has been interrupted.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sayHello() {
        String string = this.synchronizer;
        synchronized (string) {
            this.m_listening = new Integer(this.m_listening + 1);
            this.m_logger.finest("Living monitorstore threads: " + this.m_listening);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sayGoodbye() {
        String string = this.synchronizer;
        synchronized (string) {
            this.m_listening = new Integer(this.m_listening - 1);
            this.synchronizer.notifyAll();
            this.m_logger.finest("Living monitorstore threads: " + this.m_listening);
        }
    }

    protected String uid2filename(String string) {
        String string2 = this.config.get("archive.ngast.testDir");
        return (string2 == null ? m_testDir : string2) + "/" + string.replace('/', '_');
    }

    private void socketsClose() throws IOException {
        if (this.m_serverSocket != null) {
            this.m_serverSocket.close();
        }
        this.m_serverSocket = null;
    }

    protected URI ensureSchemaExists(String string) throws PermissionDeniedException, UserDoesNotExistException, ModuleCriticalException, ArchiveException {
        SchemaManager schemaManager = this.m_operArchiveComp.getSchemaManager(m_userName);
        try {
            URI uRI = schemaManager.getSchemaURI(string);
            try {
                if (uRI.equals(new URI("http://null"))) {
                    throw new UnknownSchemaException();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
            return uRI;
        }
        catch (UnknownSchemaException unknownSchemaException) {
            URI uRI = InternalIFFactory.getIdentifierManager((Logger)this.m_logger).getIdNamespace();
            this.m_logger.info("Adding dummy schema " + string + ": " + uRI.toString());
            schemaManager.addSchema(string, "<foo/>", "<dad><validation>NO</validation><Xcolumn/></dad>", uRI, m_userName, new Permissions());
            return uRI;
        }
    }

    private String getAttVal(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"=");
        while (stringTokenizer.hasMoreTokens()) {
            if (!stringTokenizer.nextToken().equals("value")) continue;
            return stringTokenizer.nextToken();
        }
        return null;
    }

    public void setComponentName(String string) {
        this.m_componentName = string;
    }

    public void setContainerServices(ContainerServices containerServices) {
        this.m_containerServices = containerServices;
        this.m_logger = this.m_containerServices.getLogger();
    }

    public void initialize(ContainerServices containerServices) throws ComponentLifecycleException {
        block4: {
            try {
                this.m_logger = containerServices.getLogger();
                this.m_logger.setLevel(Level.ALL);
                this.m_containerServices = containerServices;
                if (this.monitorNotifyChannel != null) break block4;
                try {
                    this.monitorNotifyChannel = new SimpleSupplier("monitorstore", (ContainerServicesBase)this.m_containerServices);
                }
                catch (AcsJException acsJException) {
                    throw new MonitorStreamStoreException("Could not initialize Notification channel monitorstore");
                }
            }
            catch (Exception exception) {
                throw new ComponentLifecycleException((Throwable)exception);
            }
        }
    }

    public void execute() throws ComponentLifecycleException {
    }

    public void cleanUp() {
        if (this.monitorNotifyChannel != null) {
            this.monitorNotifyChannel.disconnect();
            this.monitorNotifyChannel = null;
        }
        try {
            this.socketsClose();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void aboutToAbort() {
        this.cleanUp();
    }

    static {
        m_schemaName = "monitorTest";
    }

    protected class OneStreamListener
    extends Thread {
        Socket m_socket;

        protected OneStreamListener(Socket socket) {
            super("OneStreamListener");
            this.m_socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStream inputStream = null;
            MonitorStreamStore.this.sayHello();
            try {
                inputStream = new BufferedInputStream(this.m_socket.getInputStream());
                MonitorStreamStore.this.processStream(inputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    inputStream.close();
                    this.m_socket.close();
                }
                catch (IOException iOException) {
                    MonitorStreamStore.this.m_logger.warning("Socket failure");
                    MonitorStreamStore.this.m_logger.warning(iOException.toString());
                    try {
                        MonitorStreamStore.this.monitorNotifyChannel.publishEvent((IDLEntity)new MonitordataStoreNotificationEvent(new ArchiveTimeStamp().toString(), "", "", "", resultType.FAILURE_COMMUNICATION));
                    }
                    catch (AcsJException acsJException) {
                        MonitorStreamStore.this.m_logger.warning("Could not publish on NC monitorstore");
                    }
                    throw new RuntimeException(iOException);
                }
                this.m_socket = null;
                MonitorStreamStore.this.sayGoodbye();
            }
        }
    }

    protected class MultiStreamListener
    extends Thread {
        protected MultiStreamListener() {
            super("MultiStreamListener");
        }

        @Override
        public void run() {
            Socket socket = null;
            while (true) {
                try {
                    while (true) {
                        socket = MonitorStreamStore.this.m_serverSocket.accept();
                        MonitorStreamStore.this.m_logger.fine("Accepted connection: " + socket.toString());
                        new OneStreamListener(socket).start();
                    }
                }
                catch (SocketException socketException) {
                    if (socketException.getMessage().equals("Socket is closed") || socketException.getMessage().equals("Socket closed")) continue;
                    MonitorStreamStore.this.m_logger.warning("Socket failure");
                    MonitorStreamStore.this.m_logger.warning(socketException.toString());
                    try {
                        MonitorStreamStore.this.monitorNotifyChannel.publishEvent((IDLEntity)new MonitordataStoreNotificationEvent(new ArchiveTimeStamp().toString(), "", "", "", resultType.FAILURE_COMMUNICATION));
                    }
                    catch (AcsJException acsJException) {
                        MonitorStreamStore.this.m_logger.warning("Could not publish on NC monitorstore");
                    }
                    throw new RuntimeException(socketException);
                }
                catch (IOException iOException) {
                    MonitorStreamStore.this.m_logger.warning("Socket failure");
                    MonitorStreamStore.this.m_logger.warning(iOException.toString());
                    try {
                        MonitorStreamStore.this.monitorNotifyChannel.publishEvent((IDLEntity)new MonitordataStoreNotificationEvent(new ArchiveTimeStamp().toString(), "", "", "", resultType.FAILURE_COMMUNICATION));
                    }
                    catch (AcsJException acsJException) {
                        MonitorStreamStore.this.m_logger.warning("Could not publish on NC monitorstore");
                    }
                    throw new RuntimeException(iOException);
                }
                break;
            }
        }
    }

    protected class NGASWriter
    extends Thread {
        PipedInputStream mimeOut;
        String m_filename;

        protected NGASWriter(PipedInputStream pipedInputStream, String string) {
            super("InOutStreamer");
            this.m_filename = string;
            this.mimeOut = pipedInputStream;
        }

        @Override
        public void run() {
            Status status = MonitorStreamStore.this.ngasJClient.archiveStream((InputStream)this.mimeOut, MonitorStreamStore.this.contentType, this.m_filename);
            System.out.println(status.getRequestStatus());
            System.out.println(status.getMessage());
        }
    }

    protected class ContinuousSingleStreamListener
    extends Thread {
        protected ContinuousSingleStreamListener() {
            super("ContinuousSingleStreamListener");
        }

        @Override
        public void run() {
            Socket socket = null;
            while (true) {
                try {
                    while (true) {
                        BufferedInputStream bufferedInputStream = null;
                        socket = MonitorStreamStore.this.m_serverSocket.accept();
                        MonitorStreamStore.this.m_logger.fine("Accepted connection: " + socket.toString());
                        bufferedInputStream = new BufferedInputStream(socket.getInputStream());
                        while (!MonitorStreamStore.this.m_listenerClosed) {
                            MonitorStreamStore.this.processStream(bufferedInputStream);
                        }
                        ((InputStream)bufferedInputStream).close();
                        socket.close();
                    }
                }
                catch (SocketException socketException) {
                    if (socketException.getMessage().equals("Socket is closed") || socketException.getMessage().equals("Socket closed")) continue;
                    MonitorStreamStore.this.m_logger.warning("Socket failure");
                    MonitorStreamStore.this.m_logger.warning(socketException.toString());
                    try {
                        MonitorStreamStore.this.monitorNotifyChannel.publishEvent((IDLEntity)new MonitordataStoreNotificationEvent(new ArchiveTimeStamp().toString(), "", "", "", resultType.FAILURE_COMMUNICATION));
                    }
                    catch (AcsJException acsJException) {
                        MonitorStreamStore.this.m_logger.warning("Could not publish on NC monitorstore");
                    }
                    throw new RuntimeException(socketException);
                }
                catch (IOException iOException) {
                    MonitorStreamStore.this.m_logger.warning("Socket failure");
                    MonitorStreamStore.this.m_logger.warning(iOException.toString());
                    try {
                        MonitorStreamStore.this.monitorNotifyChannel.publishEvent((IDLEntity)new MonitordataStoreNotificationEvent(new ArchiveTimeStamp().toString(), "", "", "", resultType.FAILURE_COMMUNICATION));
                    }
                    catch (AcsJException acsJException) {
                        MonitorStreamStore.this.m_logger.warning("Could not publish on NC monitorstore");
                    }
                    throw new RuntimeException(iOException);
                }
                break;
            }
        }
    }

    protected class SingleStreamListener
    extends Thread {
        protected SingleStreamListener() {
            super("SingleStreamListener");
        }

        @Override
        public void run() {
            Socket socket = null;
            long l = System.currentTimeMillis();
            try {
                MonitorStreamStore.this.m_serverSocket.setSoTimeout((int)MonitorStreamStore.this.TIMEOUT);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            while (System.currentTimeMillis() < l + MonitorStreamStore.this.TIMEOUT) {
                try {
                    BufferedInputStream bufferedInputStream = null;
                    socket = MonitorStreamStore.this.m_serverSocket.accept();
                    MonitorStreamStore.this.m_logger.fine("Accepted connection: " + socket.toString());
                    bufferedInputStream = new BufferedInputStream(socket.getInputStream());
                    try {
                        MonitorStreamStore.this.processStream(bufferedInputStream);
                    }
                    catch (Exception exception) {
                        MonitorStreamStore.this.m_logger.warning("Catched exception while processing incoming stream: " + exception.toString());
                    }
                    ((InputStream)bufferedInputStream).close();
                    socket.close();
                }
                catch (SocketException socketException) {
                    if (socketException.getMessage().equals("Socket is closed") || socketException.getMessage().equals("Socket closed")) continue;
                    MonitorStreamStore.this.m_logger.warning("Socket failure");
                    MonitorStreamStore.this.m_logger.warning(socketException.toString());
                    try {
                        MonitorStreamStore.this.monitorNotifyChannel.publishEvent((IDLEntity)new MonitordataStoreNotificationEvent(new ArchiveTimeStamp().toString(), "", "", "", resultType.FAILURE_COMMUNICATION));
                    }
                    catch (AcsJException acsJException) {
                        MonitorStreamStore.this.m_logger.warning("Could not publish on NC monitorstore");
                    }
                    throw new RuntimeException(socketException);
                }
                catch (IOException iOException) {
                    MonitorStreamStore.this.m_logger.warning("Socket failure");
                    MonitorStreamStore.this.m_logger.warning(iOException.toString());
                    try {
                        MonitorStreamStore.this.monitorNotifyChannel.publishEvent((IDLEntity)new MonitordataStoreNotificationEvent(new ArchiveTimeStamp().toString(), "", "", "", resultType.FAILURE_COMMUNICATION));
                    }
                    catch (AcsJException acsJException) {
                        MonitorStreamStore.this.m_logger.warning("Could not publish on NC monitorstore");
                    }
                    throw new RuntimeException(iOException);
                }
            }
        }
    }
}

