/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

public final class ZipShort
implements Cloneable {
    private static final int BYTE_MASK = 255;
    private static final int BYTE_1_MASK = 65280;
    private static final int BYTE_1_SHIFT = 8;
    private int value;

    public ZipShort(int n) {
        this.value = n;
    }

    public ZipShort(byte[] byArray) {
        this(byArray, 0);
    }

    public ZipShort(byte[] byArray, int n) {
        this.value = ZipShort.getValue(byArray, n);
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[]{(byte)(this.value & 0xFF), (byte)((this.value & 0xFF00) >> 8)};
        return byArray;
    }

    public int getValue() {
        return this.value;
    }

    public static byte[] getBytes(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)((n & 0xFF00) >> 8)};
        return byArray;
    }

    public static int getValue(byte[] byArray, int n) {
        int n2 = byArray[n + 1] << 8 & 0xFF00;
        return n2 += byArray[n] & 0xFF;
    }

    public static int getValue(byte[] byArray) {
        return ZipShort.getValue(byArray, 0);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ZipShort)) {
            return false;
        }
        return this.value == ((ZipShort)object).getValue();
    }

    public int hashCode() {
        return this.value;
    }
}

