/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.IOException;
import java.io.Reader;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.util.StringUtils;
import org.apache.tools.ant.util.Tokenizer;

public class StringTokenizer
extends ProjectComponent
implements Tokenizer {
    private static final int NOT_A_CHAR = -2;
    private String intraString = "";
    private int pushed = -2;
    private char[] delims = null;
    private boolean delimsAreTokens = false;
    private boolean suppressDelims = false;
    private boolean includeDelims = false;

    public void setDelims(String string) {
        this.delims = StringUtils.resolveBackSlash(string).toCharArray();
    }

    public void setDelimsAreTokens(boolean bl) {
        this.delimsAreTokens = bl;
    }

    public void setSuppressDelims(boolean bl) {
        this.suppressDelims = bl;
    }

    public void setIncludeDelims(boolean bl) {
        this.includeDelims = bl;
    }

    @Override
    public String getToken(Reader reader) throws IOException {
        int n = -1;
        if (this.pushed != -2) {
            n = this.pushed;
            this.pushed = -2;
        } else {
            n = reader.read();
        }
        if (n == -1) {
            return null;
        }
        boolean bl = true;
        this.intraString = "";
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        while (n != -1) {
            char c = (char)n;
            boolean bl2 = this.isDelim(c);
            if (bl) {
                if (bl2) {
                    if (this.delimsAreTokens) {
                        if (stringBuffer.length() == 0) {
                            stringBuffer.append(c);
                            break;
                        }
                        this.pushed = n;
                        break;
                    }
                    stringBuffer2.append(c);
                    bl = false;
                } else {
                    stringBuffer.append(c);
                }
            } else if (bl2) {
                stringBuffer2.append(c);
            } else {
                this.pushed = n;
                break;
            }
            n = reader.read();
        }
        this.intraString = stringBuffer2.toString();
        if (this.includeDelims) {
            stringBuffer.append(this.intraString);
        }
        return stringBuffer.toString();
    }

    @Override
    public String getPostToken() {
        return this.suppressDelims || this.includeDelims ? "" : this.intraString;
    }

    private boolean isDelim(char c) {
        if (this.delims == null) {
            return Character.isWhitespace(c);
        }
        for (int i = 0; i < this.delims.length; ++i) {
            if (this.delims[i] != c) continue;
            return true;
        }
        return false;
    }
}

