/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tools.ant.BuildException;

public class ReflectUtil {
    private ReflectUtil() {
    }

    public static Object invoke(Object object, String string) {
        try {
            Method method = object.getClass().getMethod(string, null);
            return method.invoke(object, (Object[])null);
        }
        catch (Exception exception) {
            ReflectUtil.throwBuildException(exception);
            return null;
        }
    }

    public static Object invokeStatic(Object object, String string) {
        try {
            Method method = ((Class)object).getMethod(string, null);
            return method.invoke(object, (Object[])null);
        }
        catch (Exception exception) {
            ReflectUtil.throwBuildException(exception);
            return null;
        }
    }

    public static Object invoke(Object object, String string, Class clazz, Object object2) {
        try {
            Method method = object.getClass().getMethod(string, clazz);
            return method.invoke(object, object2);
        }
        catch (Exception exception) {
            ReflectUtil.throwBuildException(exception);
            return null;
        }
    }

    public static Object invoke(Object object, String string, Class clazz, Object object2, Class clazz2, Object object3) {
        try {
            Method method = object.getClass().getMethod(string, clazz, clazz2);
            return method.invoke(object, object2, object3);
        }
        catch (Exception exception) {
            ReflectUtil.throwBuildException(exception);
            return null;
        }
    }

    public static Object getField(Object object, String string) throws BuildException {
        try {
            Field field = object.getClass().getDeclaredField(string);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception exception) {
            ReflectUtil.throwBuildException(exception);
            return null;
        }
    }

    public static void throwBuildException(Exception exception) throws BuildException {
        throw ReflectUtil.toBuildException(exception);
    }

    public static BuildException toBuildException(Exception exception) {
        if (exception instanceof InvocationTargetException) {
            Throwable throwable = ((InvocationTargetException)exception).getTargetException();
            if (throwable instanceof BuildException) {
                return (BuildException)throwable;
            }
            return new BuildException(throwable);
        }
        return new BuildException(exception);
    }

    public static boolean respondsTo(Object object, String string) throws BuildException {
        try {
            Method[] methodArray = object.getClass().getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().equals(string)) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            throw ReflectUtil.toBuildException(exception);
        }
    }
}

