/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import org.apache.tools.ant.Project;

public class ProxySetup {
    private Project owner;
    public static final String USE_SYSTEM_PROXIES = "java.net.useSystemProxies";
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTPS_PROXY_HOST = "https.proxyHost";
    public static final String HTTPS_PROXY_PORT = "https.proxyPort";
    public static final String FTP_PROXY_HOST = "ftp.proxyHost";
    public static final String FTP_PROXY_PORT = "ftp.proxyPort";
    public static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    public static final String HTTPS_NON_PROXY_HOSTS = "https.nonProxyHosts";
    public static final String FTP_NON_PROXY_HOSTS = "ftp.nonProxyHosts";
    public static final String HTTP_PROXY_USERNAME = "http.proxyUser";
    public static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    public static final String SOCKS_PROXY_HOST = "socksProxyHost";
    public static final String SOCKS_PROXY_PORT = "socksProxyPort";
    public static final String SOCKS_PROXY_USERNAME = "java.net.socks.username";
    public static final String SOCKS_PROXY_PASSWORD = "java.net.socks.password";

    public ProxySetup(Project project) {
        this.owner = project;
    }

    public static String getSystemProxySetting() {
        try {
            return System.getProperty(USE_SYSTEM_PROXIES);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public void enableProxies() {
        if (ProxySetup.getSystemProxySetting() == null) {
            String string = this.owner.getProperty(USE_SYSTEM_PROXIES);
            if (string == null || Project.toBoolean(string)) {
                string = "true";
            }
            String string2 = "setting java.net.useSystemProxies to " + string;
            try {
                this.owner.log(string2, 4);
                System.setProperty(USE_SYSTEM_PROXIES, string);
            }
            catch (SecurityException securityException) {
                this.owner.log("Security Exception when " + string2);
            }
        }
    }
}

