/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.launch.Locator;
import org.apache.tools.ant.util.FileUtils;

public class LoaderUtils {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();

    public static void setContextClassLoader(ClassLoader classLoader) {
        Thread thread = Thread.currentThread();
        thread.setContextClassLoader(classLoader);
    }

    public static ClassLoader getContextClassLoader() {
        Thread thread = Thread.currentThread();
        return thread.getContextClassLoader();
    }

    public static boolean isContextLoaderAvailable() {
        return true;
    }

    private static File normalizeSource(File file) {
        if (file != null) {
            try {
                file = FILE_UTILS.normalize(file.getAbsolutePath());
            }
            catch (BuildException buildException) {
                // empty catch block
            }
        }
        return file;
    }

    public static File getClassSource(Class clazz) {
        return LoaderUtils.normalizeSource(Locator.getClassSource((Class)clazz));
    }

    public static File getResourceSource(ClassLoader classLoader, String string) {
        if (classLoader == null) {
            classLoader = LoaderUtils.class.getClassLoader();
        }
        return LoaderUtils.normalizeSource(Locator.getResourceSource((ClassLoader)classLoader, (String)string));
    }

    public static String classNameToResource(String string) {
        return string.replace('.', '/') + ".class";
    }

    public static boolean classExists(ClassLoader classLoader, String string) {
        return classLoader.getResource(LoaderUtils.classNameToResource(string)) != null;
    }
}

