/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import org.apache.tools.ant.util.FileNameMapper;

public class GlobPatternMapper
implements FileNameMapper {
    protected String fromPrefix = null;
    protected String fromPostfix = null;
    protected int prefixLength;
    protected int postfixLength;
    protected String toPrefix = null;
    protected String toPostfix = null;
    private boolean handleDirSep = false;
    private boolean caseSensitive = true;

    public void setHandleDirSep(boolean bl) {
        this.handleDirSep = bl;
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    @Override
    public void setFrom(String string) {
        int n = string.lastIndexOf("*");
        if (n == -1) {
            this.fromPrefix = string;
            this.fromPostfix = "";
        } else {
            this.fromPrefix = string.substring(0, n);
            this.fromPostfix = string.substring(n + 1);
        }
        this.prefixLength = this.fromPrefix.length();
        this.postfixLength = this.fromPostfix.length();
    }

    @Override
    public void setTo(String string) {
        int n = string.lastIndexOf("*");
        if (n == -1) {
            this.toPrefix = string;
            this.toPostfix = "";
        } else {
            this.toPrefix = string.substring(0, n);
            this.toPostfix = string.substring(n + 1);
        }
    }

    @Override
    public String[] mapFileName(String string) {
        if (this.fromPrefix == null || !this.modifyName(string).startsWith(this.modifyName(this.fromPrefix)) || !this.modifyName(string).endsWith(this.modifyName(this.fromPostfix))) {
            return null;
        }
        return new String[]{this.toPrefix + this.extractVariablePart(string) + this.toPostfix};
    }

    protected String extractVariablePart(String string) {
        return string.substring(this.prefixLength, string.length() - this.postfixLength);
    }

    private String modifyName(String string) {
        if (!this.caseSensitive) {
            string = string.toLowerCase();
        }
        if (this.handleDirSep && string.indexOf(92) != -1) {
            string = string.replace('\\', '/');
        }
        return string;
    }
}

