/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors.modifiedselector;

import java.io.File;
import java.util.Comparator;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;
import org.apache.tools.ant.types.selectors.modifiedselector.Algorithm;
import org.apache.tools.ant.types.selectors.modifiedselector.Cache;
import org.apache.tools.ant.types.selectors.modifiedselector.ChecksumAlgorithm;
import org.apache.tools.ant.types.selectors.modifiedselector.DigestAlgorithm;
import org.apache.tools.ant.types.selectors.modifiedselector.EqualComparator;
import org.apache.tools.ant.types.selectors.modifiedselector.HashvalueAlgorithm;
import org.apache.tools.ant.types.selectors.modifiedselector.PropertiesfileCache;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.ResourceUtils;

public class ModifiedSelector
extends BaseExtendSelector
implements BuildListener,
ResourceSelector {
    private static final String CACHE_START = "cache.";
    private static final String ALGORITHM_START = "algorithm.";
    private static final String COMPARATOR_START = "comparator.";
    private CacheName cacheName = null;
    private String cacheClass;
    private AlgorithmName algoName = null;
    private String algorithmClass;
    private ComparatorName compName = null;
    private String comparatorClass;
    private boolean update = true;
    private boolean selectDirectories = true;
    private boolean selectResourcesWithoutInputStream = true;
    private boolean delayUpdate = true;
    private Comparator comparator = null;
    private Algorithm algorithm = null;
    private Cache cache = null;
    private int modified = 0;
    private boolean isConfigured = false;
    private Vector configParameter = new Vector();
    private Vector specialParameter = new Vector();
    private ClassLoader myClassLoader = null;
    private Path classpath = null;

    @Override
    public void verifySettings() {
        this.configure();
        if (this.cache == null) {
            this.setError("Cache must be set.");
        } else if (this.algorithm == null) {
            this.setError("Algorithm must be set.");
        } else if (!this.cache.isValid()) {
            this.setError("Cache must be proper configured.");
        } else if (!this.algorithm.isValid()) {
            this.setError("Algorithm must be proper configured.");
        }
    }

    public void configure() {
        if (this.isConfigured) {
            return;
        }
        this.isConfigured = true;
        Project project = this.getProject();
        String string = "cache.properties";
        File file = null;
        if (project != null) {
            file = new File(project.getBaseDir(), string);
            this.getProject().addBuildListener(this);
        } else {
            file = new File(string);
            this.setDelayUpdate(false);
        }
        PropertiesfileCache propertiesfileCache = new PropertiesfileCache(file);
        DigestAlgorithm digestAlgorithm = new DigestAlgorithm();
        EqualComparator equalComparator = new EqualComparator();
        this.update = true;
        this.selectDirectories = true;
        for (Parameter parameter : this.configParameter) {
            if (parameter.getName().indexOf(".") > 0) {
                this.specialParameter.add(parameter);
                continue;
            }
            this.useParameter(parameter);
        }
        this.configParameter = new Vector();
        if (this.algoName != null) {
            if ("hashvalue".equals(this.algoName.getValue())) {
                this.algorithm = new HashvalueAlgorithm();
            } else if ("digest".equals(this.algoName.getValue())) {
                this.algorithm = new DigestAlgorithm();
            } else if ("checksum".equals(this.algoName.getValue())) {
                this.algorithm = new ChecksumAlgorithm();
            }
        } else {
            this.algorithm = this.algorithmClass != null ? (Algorithm)this.loadClass(this.algorithmClass, "is not an Algorithm.", Algorithm.class) : digestAlgorithm;
        }
        if (this.cacheName != null) {
            if ("propertyfile".equals(this.cacheName.getValue())) {
                this.cache = new PropertiesfileCache();
            }
        } else {
            this.cache = this.cacheClass != null ? (Cache)this.loadClass(this.cacheClass, "is not a Cache.", Cache.class) : propertiesfileCache;
        }
        if (this.compName != null) {
            if ("equal".equals(this.compName.getValue())) {
                this.comparator = new EqualComparator();
            } else if ("rule".equals(this.compName.getValue())) {
                throw new BuildException("RuleBasedCollator not yet supported.");
            }
        } else {
            this.comparator = this.comparatorClass != null ? (Comparator)this.loadClass(this.comparatorClass, "is not a Comparator.", Comparator.class) : equalComparator;
        }
        for (Parameter parameter : this.specialParameter) {
            this.useParameter(parameter);
        }
        this.specialParameter = new Vector();
    }

    protected Object loadClass(String string, String string2, Class clazz) {
        try {
            ClassLoader classLoader = this.getClassLoader();
            Class<?> clazz2 = null;
            clazz2 = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
            Object obj = clazz2.newInstance();
            if (!clazz.isInstance(obj)) {
                throw new BuildException("Specified class (" + string + ") " + string2);
            }
            return obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException("Specified class (" + string + ") not found.");
        }
        catch (Exception exception) {
            throw new BuildException(exception);
        }
    }

    @Override
    public boolean isSelected(Resource resource) {
        if (resource.isFilesystemOnly()) {
            FileResource fileResource = (FileResource)resource;
            File file = fileResource.getFile();
            String string = fileResource.getName();
            File file2 = fileResource.getBaseDir();
            return this.isSelected(file2, string, file);
        }
        try {
            FileUtils fileUtils = FileUtils.getFileUtils();
            File file = fileUtils.createTempFile("modified-", ".tmp", null, true, true);
            FileResource fileResource = new FileResource(file);
            ResourceUtils.copyResource(resource, fileResource);
            boolean bl = this.isSelected(file.getParentFile(), file.getName(), resource.toLongString());
            return bl;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.log("The resource '" + resource.getName() + "' does not provide an InputStream, so it is not checked. " + "Akkording to 'selres' attribute value it is " + (this.selectResourcesWithoutInputStream ? "" : " not") + "selected.", 2);
            return this.selectResourcesWithoutInputStream;
        }
        catch (Exception exception) {
            throw new BuildException(exception);
        }
    }

    @Override
    public boolean isSelected(File file, String string, File file2) {
        return this.isSelected(file, string, file2.getAbsolutePath());
    }

    private boolean isSelected(File file, String string, String string2) {
        String string3;
        boolean bl;
        this.validate();
        File file2 = new File(file, string);
        if (file2.isDirectory()) {
            return this.selectDirectories;
        }
        String string4 = String.valueOf(this.cache.get(file2.getAbsolutePath()));
        boolean bl2 = bl = this.comparator.compare(string4, string3 = this.algorithm.getValue(file2)) != 0;
        if (this.update && bl) {
            this.cache.put(file2.getAbsolutePath(), string3);
            this.setModified(this.getModified() + 1);
            if (!this.getDelayUpdate()) {
                this.saveCache();
            }
        }
        return bl;
    }

    protected void saveCache() {
        if (this.getModified() > 0) {
            this.cache.save();
            this.setModified(0);
        }
    }

    public void setAlgorithmClass(String string) {
        this.algorithmClass = string;
    }

    public void setComparatorClass(String string) {
        this.comparatorClass = string;
    }

    public void setCacheClass(String string) {
        this.cacheClass = string;
    }

    public void setUpdate(boolean bl) {
        this.update = bl;
    }

    public void setSeldirs(boolean bl) {
        this.selectDirectories = bl;
    }

    public void setSelres(boolean bl) {
        this.selectResourcesWithoutInputStream = bl;
    }

    public int getModified() {
        return this.modified;
    }

    public void setModified(int n) {
        this.modified = n;
    }

    public boolean getDelayUpdate() {
        return this.delayUpdate;
    }

    public void setDelayUpdate(boolean bl) {
        this.delayUpdate = bl;
    }

    public void addClasspath(Path path) {
        if (this.classpath != null) {
            throw new BuildException("<classpath> can be set only once.");
        }
        this.classpath = path;
    }

    public ClassLoader getClassLoader() {
        if (this.myClassLoader == null) {
            this.myClassLoader = this.classpath == null ? this.getClass().getClassLoader() : this.getProject().createClassLoader(this.classpath);
        }
        return this.myClassLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.myClassLoader = classLoader;
    }

    public void addParam(String string, Object object) {
        Parameter parameter = new Parameter();
        parameter.setName(string);
        parameter.setValue(String.valueOf(object));
        this.configParameter.add(parameter);
    }

    public void addParam(Parameter parameter) {
        this.configParameter.add(parameter);
    }

    @Override
    public void setParameters(Parameter[] parameterArray) {
        if (parameterArray != null) {
            for (int i = 0; i < parameterArray.length; ++i) {
                this.configParameter.add(parameterArray[i]);
            }
        }
    }

    public void useParameter(Parameter parameter) {
        String string = parameter.getName();
        String string2 = parameter.getValue();
        if ("cache".equals(string)) {
            CacheName cacheName = new CacheName();
            cacheName.setValue(string2);
            this.setCache(cacheName);
        } else if ("algorithm".equals(string)) {
            AlgorithmName algorithmName = new AlgorithmName();
            algorithmName.setValue(string2);
            this.setAlgorithm(algorithmName);
        } else if ("comparator".equals(string)) {
            ComparatorName comparatorName = new ComparatorName();
            comparatorName.setValue(string2);
            this.setComparator(comparatorName);
        } else if ("update".equals(string)) {
            boolean bl = "true".equalsIgnoreCase(string2);
            this.setUpdate(bl);
        } else if ("delayupdate".equals(string)) {
            boolean bl = "true".equalsIgnoreCase(string2);
            this.setDelayUpdate(bl);
        } else if ("seldirs".equals(string)) {
            boolean bl = "true".equalsIgnoreCase(string2);
            this.setSeldirs(bl);
        } else if (string.startsWith(CACHE_START)) {
            String string3 = string.substring(CACHE_START.length());
            this.tryToSetAParameter(this.cache, string3, string2);
        } else if (string.startsWith(ALGORITHM_START)) {
            String string4 = string.substring(ALGORITHM_START.length());
            this.tryToSetAParameter(this.algorithm, string4, string2);
        } else if (string.startsWith(COMPARATOR_START)) {
            String string5 = string.substring(COMPARATOR_START.length());
            this.tryToSetAParameter(this.comparator, string5, string2);
        } else {
            this.setError("Invalid parameter " + string);
        }
    }

    protected void tryToSetAParameter(Object object, String string, String string2) {
        Project project = this.getProject() != null ? this.getProject() : new Project();
        IntrospectionHelper introspectionHelper = IntrospectionHelper.getHelper(project, object.getClass());
        try {
            introspectionHelper.setAttribute(project, object, string, string2);
        }
        catch (BuildException buildException) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{modifiedselector");
        stringBuffer.append(" update=").append(this.update);
        stringBuffer.append(" seldirs=").append(this.selectDirectories);
        stringBuffer.append(" cache=").append(this.cache);
        stringBuffer.append(" algorithm=").append(this.algorithm);
        stringBuffer.append(" comparator=").append(this.comparator);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    @Override
    public void buildFinished(BuildEvent buildEvent) {
        if (this.getDelayUpdate()) {
            this.saveCache();
        }
    }

    @Override
    public void targetFinished(BuildEvent buildEvent) {
        if (this.getDelayUpdate()) {
            this.saveCache();
        }
    }

    @Override
    public void taskFinished(BuildEvent buildEvent) {
        if (this.getDelayUpdate()) {
            this.saveCache();
        }
    }

    @Override
    public void buildStarted(BuildEvent buildEvent) {
    }

    @Override
    public void targetStarted(BuildEvent buildEvent) {
    }

    @Override
    public void taskStarted(BuildEvent buildEvent) {
    }

    @Override
    public void messageLogged(BuildEvent buildEvent) {
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(CacheName cacheName) {
        this.cacheName = cacheName;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(AlgorithmName algorithmName) {
        this.algoName = algorithmName;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(ComparatorName comparatorName) {
        this.compName = comparatorName;
    }

    public static class ComparatorName
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{"equal", "rule"};
        }
    }

    public static class AlgorithmName
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{"hashvalue", "digest", "checksum"};
        }
    }

    public static class CacheName
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{"propertyfile"};
        }
    }
}

