/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors.modifiedselector;

import java.io.File;
import java.io.FileInputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.selectors.modifiedselector.Algorithm;

public class DigestAlgorithm
implements Algorithm {
    private static final int BYTE_MASK = 255;
    private static final int BUFFER_SIZE = 8192;
    private String algorithm = "MD5";
    private String provider = null;
    private MessageDigest messageDigest = null;
    private int readBufferSize = 8192;

    public void setAlgorithm(String string) {
        this.algorithm = string;
    }

    public void setProvider(String string) {
        this.provider = string;
    }

    public void initMessageDigest() {
        if (this.messageDigest != null) {
            return;
        }
        if (this.provider != null && !"".equals(this.provider) && !"null".equals(this.provider)) {
            try {
                this.messageDigest = MessageDigest.getInstance(this.algorithm, this.provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new BuildException(noSuchAlgorithmException);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new BuildException(noSuchProviderException);
            }
        }
        try {
            this.messageDigest = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new BuildException(noSuchAlgorithmException);
        }
    }

    @Override
    public boolean isValid() {
        return "SHA".equalsIgnoreCase(this.algorithm) || "MD5".equalsIgnoreCase(this.algorithm);
    }

    @Override
    public String getValue(File file) {
        this.initMessageDigest();
        String string = null;
        try {
            if (!file.canRead()) {
                return null;
            }
            FileInputStream fileInputStream = null;
            byte[] byArray = new byte[this.readBufferSize];
            try {
                this.messageDigest.reset();
                fileInputStream = new FileInputStream(file);
                DigestInputStream digestInputStream = new DigestInputStream(fileInputStream, this.messageDigest);
                while (digestInputStream.read(byArray, 0, this.readBufferSize) != -1) {
                }
                digestInputStream.close();
                fileInputStream.close();
                fileInputStream = null;
                byte[] byArray2 = this.messageDigest.digest();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < byArray2.length; ++i) {
                    String string2 = Integer.toHexString(0xFF & byArray2[i]);
                    if (string2.length() < 2) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(string2);
                }
                string = stringBuffer.toString();
            }
            catch (Exception exception) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<DigestAlgorithm:");
        stringBuffer.append("algorithm=").append(this.algorithm);
        stringBuffer.append(";provider=").append(this.provider);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

