/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;

public class TypeSelector
extends BaseExtendSelector {
    private String type = null;
    public static final String TYPE_KEY = "type";

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{typeselector type: ");
        stringBuffer.append(this.type);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void setType(FileType fileType) {
        this.type = fileType.getValue();
    }

    @Override
    public void setParameters(Parameter[] parameterArray) {
        super.setParameters(parameterArray);
        if (parameterArray != null) {
            for (int i = 0; i < parameterArray.length; ++i) {
                String string = parameterArray[i].getName();
                if (TYPE_KEY.equalsIgnoreCase(string)) {
                    FileType fileType = new FileType();
                    fileType.setValue(parameterArray[i].getValue());
                    this.setType(fileType);
                    continue;
                }
                this.setError("Invalid parameter " + string);
            }
        }
    }

    @Override
    public void verifySettings() {
        if (this.type == null) {
            this.setError("The type attribute is required");
        }
    }

    @Override
    public boolean isSelected(File file, String string, File file2) {
        this.validate();
        if (file2.isDirectory()) {
            return this.type.equals("dir");
        }
        return this.type.equals("file");
    }

    public static class FileType
    extends EnumeratedAttribute {
        public static final String FILE = "file";
        public static final String DIR = "dir";

        @Override
        public String[] getValues() {
            return new String[]{FILE, DIR};
        }
    }
}

