/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import org.apache.tools.ant.types.Comparison;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;

public class SizeSelector
extends BaseExtendSelector {
    private static final int KILO = 1000;
    private static final int KIBI = 1024;
    private static final int KIBI_POS = 4;
    private static final int MEGA = 1000000;
    private static final int MEGA_POS = 9;
    private static final int MEBI = 0x100000;
    private static final int MEBI_POS = 13;
    private static final long GIGA = 1000000000L;
    private static final int GIGA_POS = 18;
    private static final long GIBI = 0x40000000L;
    private static final int GIBI_POS = 22;
    private static final long TERA = 1000000000000L;
    private static final int TERA_POS = 27;
    private static final long TEBI = 0x10000000000L;
    private static final int TEBI_POS = 31;
    private static final int END_POS = 36;
    public static final String SIZE_KEY = "value";
    public static final String UNITS_KEY = "units";
    public static final String WHEN_KEY = "when";
    private long size = -1L;
    private long multiplier = 1L;
    private long sizelimit = -1L;
    private Comparison when = Comparison.EQUAL;

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{sizeselector value: ");
        stringBuffer.append(this.sizelimit);
        stringBuffer.append("compare: ").append(this.when.getValue());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void setValue(long l) {
        this.size = l;
        if (this.multiplier != 0L && l > -1L) {
            this.sizelimit = l * this.multiplier;
        }
    }

    public void setUnits(ByteUnits byteUnits) {
        int n = byteUnits.getIndex();
        this.multiplier = 0L;
        if (n > -1 && n < 4) {
            this.multiplier = 1000L;
        } else if (n < 9) {
            this.multiplier = 1024L;
        } else if (n < 13) {
            this.multiplier = 1000000L;
        } else if (n < 18) {
            this.multiplier = 0x100000L;
        } else if (n < 22) {
            this.multiplier = 1000000000L;
        } else if (n < 27) {
            this.multiplier = 0x40000000L;
        } else if (n < 31) {
            this.multiplier = 1000000000000L;
        } else if (n < 36) {
            this.multiplier = 0x10000000000L;
        }
        if (this.multiplier > 0L && this.size > -1L) {
            this.sizelimit = this.size * this.multiplier;
        }
    }

    public void setWhen(SizeComparisons sizeComparisons) {
        this.when = sizeComparisons;
    }

    @Override
    public void setParameters(Parameter[] parameterArray) {
        super.setParameters(parameterArray);
        if (parameterArray != null) {
            for (int i = 0; i < parameterArray.length; ++i) {
                EnumeratedAttribute enumeratedAttribute;
                String string = parameterArray[i].getName();
                if (SIZE_KEY.equalsIgnoreCase(string)) {
                    try {
                        this.setValue(Long.parseLong(parameterArray[i].getValue()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setError("Invalid size setting " + parameterArray[i].getValue());
                    }
                    continue;
                }
                if (UNITS_KEY.equalsIgnoreCase(string)) {
                    enumeratedAttribute = new ByteUnits();
                    enumeratedAttribute.setValue(parameterArray[i].getValue());
                    this.setUnits((ByteUnits)enumeratedAttribute);
                    continue;
                }
                if (WHEN_KEY.equalsIgnoreCase(string)) {
                    enumeratedAttribute = new SizeComparisons();
                    enumeratedAttribute.setValue(parameterArray[i].getValue());
                    this.setWhen((SizeComparisons)enumeratedAttribute);
                    continue;
                }
                this.setError("Invalid parameter " + string);
            }
        }
    }

    @Override
    public void verifySettings() {
        if (this.size < 0L) {
            this.setError("The value attribute is required, and must be positive");
        } else if (this.multiplier < 1L) {
            this.setError("Invalid Units supplied, must be K,Ki,M,Mi,G,Gi,T,or Ti");
        } else if (this.sizelimit < 0L) {
            this.setError("Internal error: Code is not setting sizelimit correctly");
        }
    }

    @Override
    public boolean isSelected(File file, String string, File file2) {
        this.validate();
        if (file2.isDirectory()) {
            return true;
        }
        long l = file2.length() - this.sizelimit;
        return this.when.evaluate(l == 0L ? 0 : (int)(l / Math.abs(l)));
    }

    public static class SizeComparisons
    extends Comparison {
    }

    public static class ByteUnits
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{"K", "k", "kilo", "KILO", "Ki", "KI", "ki", "kibi", "KIBI", "M", "m", "mega", "MEGA", "Mi", "MI", "mi", "mebi", "MEBI", "G", "g", "giga", "GIGA", "Gi", "GI", "gi", "gibi", "GIBI", "T", "t", "tera", "TERA", "Ti", "TI", "ti", "tebi", "TEBI"};
        }
    }
}

