/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import java.util.Enumeration;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.selectors.BaseSelectorContainer;
import org.apache.tools.ant.types.selectors.FileSelector;

public class SelectSelector
extends BaseSelectorContainer {
    private String ifProperty;
    private String unlessProperty;

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hasSelectors()) {
            stringBuffer.append("{select");
            if (this.ifProperty != null) {
                stringBuffer.append(" if: ");
                stringBuffer.append(this.ifProperty);
            }
            if (this.unlessProperty != null) {
                stringBuffer.append(" unless: ");
                stringBuffer.append(this.unlessProperty);
            }
            stringBuffer.append(" ");
            stringBuffer.append(super.toString());
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }

    private SelectSelector getRef() {
        Object object = this.getCheckedRef(this.getClass(), "SelectSelector");
        return (SelectSelector)object;
    }

    @Override
    public boolean hasSelectors() {
        if (this.isReference()) {
            return this.getRef().hasSelectors();
        }
        return super.hasSelectors();
    }

    @Override
    public int selectorCount() {
        if (this.isReference()) {
            return this.getRef().selectorCount();
        }
        return super.selectorCount();
    }

    @Override
    public FileSelector[] getSelectors(Project project) {
        if (this.isReference()) {
            return this.getRef().getSelectors(project);
        }
        return super.getSelectors(project);
    }

    @Override
    public Enumeration selectorElements() {
        if (this.isReference()) {
            return this.getRef().selectorElements();
        }
        return super.selectorElements();
    }

    @Override
    public void appendSelector(FileSelector fileSelector) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        super.appendSelector(fileSelector);
    }

    @Override
    public void verifySettings() {
        int n = this.selectorCount();
        if (n < 0 || n > 1) {
            this.setError("Only one selector is allowed within the <selector> tag");
        }
    }

    public boolean passesConditions() {
        if (this.ifProperty != null && this.getProject().getProperty(this.ifProperty) == null) {
            return false;
        }
        return this.unlessProperty == null || this.getProject().getProperty(this.unlessProperty) == null;
    }

    public void setIf(String string) {
        this.ifProperty = string;
    }

    public void setUnless(String string) {
        this.unlessProperty = string;
    }

    @Override
    public boolean isSelected(File file, String string, File file2) {
        this.validate();
        if (!this.passesConditions()) {
            return false;
        }
        Enumeration enumeration = this.selectorElements();
        if (!enumeration.hasMoreElements()) {
            return true;
        }
        FileSelector fileSelector = (FileSelector)enumeration.nextElement();
        return fileSelector.isSelected(file, string, file2);
    }
}

