/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.TimeComparison;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;
import org.apache.tools.ant.util.FileUtils;

public class DateSelector
extends BaseExtendSelector {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private long millis = -1L;
    private String dateTime = null;
    private boolean includeDirs = false;
    private long granularity = 0L;
    private String pattern;
    private TimeComparison when = TimeComparison.EQUAL;
    public static final String MILLIS_KEY = "millis";
    public static final String DATETIME_KEY = "datetime";
    public static final String CHECKDIRS_KEY = "checkdirs";
    public static final String GRANULARITY_KEY = "granularity";
    public static final String WHEN_KEY = "when";
    public static final String PATTERN_KEY = "pattern";

    public DateSelector() {
        this.granularity = FILE_UTILS.getFileTimestampGranularity();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{dateselector date: ");
        stringBuffer.append(this.dateTime);
        stringBuffer.append(" compare: ").append(this.when.getValue());
        stringBuffer.append(" granularity: ");
        stringBuffer.append(this.granularity);
        if (this.pattern != null) {
            stringBuffer.append(" pattern: ").append(this.pattern);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void setMillis(long l) {
        this.millis = l;
    }

    public long getMillis() {
        if (this.dateTime != null) {
            this.validate();
        }
        return this.millis;
    }

    public void setDatetime(String string) {
        this.dateTime = string;
        this.millis = -1L;
    }

    public void setCheckdirs(boolean bl) {
        this.includeDirs = bl;
    }

    public void setGranularity(int n) {
        this.granularity = n;
    }

    public void setWhen(TimeComparisons timeComparisons) {
        this.setWhen((TimeComparison)timeComparisons);
    }

    public void setWhen(TimeComparison timeComparison) {
        this.when = timeComparison;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    @Override
    public void setParameters(Parameter[] parameterArray) {
        super.setParameters(parameterArray);
        if (parameterArray != null) {
            for (int i = 0; i < parameterArray.length; ++i) {
                String string = parameterArray[i].getName();
                if (MILLIS_KEY.equalsIgnoreCase(string)) {
                    try {
                        this.setMillis(Long.parseLong(parameterArray[i].getValue()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setError("Invalid millisecond setting " + parameterArray[i].getValue());
                    }
                    continue;
                }
                if (DATETIME_KEY.equalsIgnoreCase(string)) {
                    this.setDatetime(parameterArray[i].getValue());
                    continue;
                }
                if (CHECKDIRS_KEY.equalsIgnoreCase(string)) {
                    this.setCheckdirs(Project.toBoolean(parameterArray[i].getValue()));
                    continue;
                }
                if (GRANULARITY_KEY.equalsIgnoreCase(string)) {
                    try {
                        this.setGranularity(Integer.parseInt(parameterArray[i].getValue()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setError("Invalid granularity setting " + parameterArray[i].getValue());
                    }
                    continue;
                }
                if (WHEN_KEY.equalsIgnoreCase(string)) {
                    this.setWhen(new TimeComparison(parameterArray[i].getValue()));
                    continue;
                }
                if (PATTERN_KEY.equalsIgnoreCase(string)) {
                    this.setPattern(parameterArray[i].getValue());
                    continue;
                }
                this.setError("Invalid parameter " + string);
            }
        }
    }

    @Override
    public void verifySettings() {
        if (this.dateTime == null && this.millis < 0L) {
            this.setError("You must provide a datetime or the number of milliseconds.");
        } else if (this.millis < 0L && this.dateTime != null) {
            DateFormat dateFormat = this.pattern == null ? DateFormat.getDateTimeInstance(3, 3, Locale.US) : new SimpleDateFormat(this.pattern);
            try {
                this.setMillis(dateFormat.parse(this.dateTime).getTime());
                if (this.millis < 0L) {
                    this.setError("Date of " + this.dateTime + " results in negative milliseconds value" + " relative to epoch (January 1, 1970, 00:00:00 GMT).");
                }
            }
            catch (ParseException parseException) {
                this.setError("Date of " + this.dateTime + " Cannot be parsed correctly. It should be in" + (this.pattern == null ? " MM/DD/YYYY HH:MM AM_PM" : this.pattern) + " format.");
            }
        }
    }

    @Override
    public boolean isSelected(File file, String string, File file2) {
        this.validate();
        return file2.isDirectory() && !this.includeDirs || this.when.evaluate(file2.lastModified(), this.millis, this.granularity);
    }

    public static class TimeComparisons
    extends TimeComparison {
    }
}

