/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileUtils;

public class ContainsSelector
extends BaseExtendSelector
implements ResourceSelector {
    private String contains = null;
    private boolean casesensitive = true;
    private boolean ignorewhitespace = false;
    public static final String EXPRESSION_KEY = "expression";
    public static final String CONTAINS_KEY = "text";
    public static final String CASE_KEY = "casesensitive";
    public static final String WHITESPACE_KEY = "ignorewhitespace";

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{containsselector text: ");
        stringBuffer.append('\"').append(this.contains).append('\"');
        stringBuffer.append(" casesensitive: ");
        stringBuffer.append(this.casesensitive ? "true" : "false");
        stringBuffer.append(" ignorewhitespace: ");
        stringBuffer.append(this.ignorewhitespace ? "true" : "false");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void setText(String string) {
        this.contains = string;
    }

    public void setCasesensitive(boolean bl) {
        this.casesensitive = bl;
    }

    public void setIgnorewhitespace(boolean bl) {
        this.ignorewhitespace = bl;
    }

    @Override
    public void setParameters(Parameter[] parameterArray) {
        super.setParameters(parameterArray);
        if (parameterArray != null) {
            for (int i = 0; i < parameterArray.length; ++i) {
                String string = parameterArray[i].getName();
                if (CONTAINS_KEY.equalsIgnoreCase(string)) {
                    this.setText(parameterArray[i].getValue());
                    continue;
                }
                if (CASE_KEY.equalsIgnoreCase(string)) {
                    this.setCasesensitive(Project.toBoolean(parameterArray[i].getValue()));
                    continue;
                }
                if (WHITESPACE_KEY.equalsIgnoreCase(string)) {
                    this.setIgnorewhitespace(Project.toBoolean(parameterArray[i].getValue()));
                    continue;
                }
                this.setError("Invalid parameter " + string);
            }
        }
    }

    @Override
    public void verifySettings() {
        if (this.contains == null) {
            this.setError("The text attribute is required");
        }
    }

    @Override
    public boolean isSelected(File file, String string, File file2) {
        return this.isSelected(new FileResource(file2));
    }

    @Override
    public boolean isSelected(Resource resource) {
        this.validate();
        if (resource.isDirectory() || this.contains.length() == 0) {
            return true;
        }
        String string = this.contains;
        if (!this.casesensitive) {
            string = this.contains.toLowerCase();
        }
        if (this.ignorewhitespace) {
            string = SelectorUtils.removeWhitespace(string);
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(resource.getInputStream()));
        }
        catch (Exception exception) {
            throw new BuildException("Could not get InputStream from " + resource.toLongString(), exception);
        }
        try {
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (!this.casesensitive) {
                    string2 = string2.toLowerCase();
                }
                if (this.ignorewhitespace) {
                    string2 = SelectorUtils.removeWhitespace(string2);
                }
                if (string2.indexOf(string) > -1) {
                    boolean bl = true;
                    return bl;
                }
                string2 = bufferedReader.readLine();
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            throw new BuildException("Could not read " + resource.toLongString());
        }
        finally {
            FileUtils.close(bufferedReader);
        }
    }
}

