/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.ArchiveResource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class ZipResource
extends ArchiveResource {
    private String encoding;

    public ZipResource() {
    }

    public ZipResource(File file, String string, ZipEntry zipEntry) {
        super(file, true);
        this.setEncoding(string);
        this.setEntry(zipEntry);
    }

    public void setZipfile(File file) {
        this.setArchive(file);
    }

    public File getZipfile() {
        FileResource fileResource = (FileResource)this.getArchive();
        return fileResource.getFile();
    }

    @Override
    public void addConfigured(ResourceCollection resourceCollection) {
        super.addConfigured(resourceCollection);
        if (!resourceCollection.isFilesystemOnly()) {
            throw new BuildException("only filesystem resources are supported");
        }
    }

    public void setEncoding(String string) {
        this.checkAttributesAllowed();
        this.encoding = string;
    }

    public String getEncoding() {
        return this.isReference() ? ((ZipResource)this.getCheckedRef()).getEncoding() : this.encoding;
    }

    @Override
    public void setRefid(Reference reference) {
        if (this.encoding != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getInputStream();
        }
        final ZipFile zipFile = new ZipFile(this.getZipfile(), this.getEncoding());
        ZipEntry zipEntry = zipFile.getEntry(this.getName());
        if (zipEntry == null) {
            zipFile.close();
            throw new BuildException("no entry " + this.getName() + " in " + this.getArchive());
        }
        return new FilterInputStream(zipFile.getInputStream(zipEntry)){

            @Override
            public void close() throws IOException {
                FileUtils.close(this.in);
                zipFile.close();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() throws Throwable {
                try {
                    this.close();
                }
                finally {
                    super.finalize();
                }
            }
        };
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getOutputStream();
        }
        throw new UnsupportedOperationException("Use the zip task for zip output.");
    }

    @Override
    protected void fetchEntry() {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.getZipfile(), this.getEncoding());
            this.setEntry(zipFile.getEntry(this.getName()));
        }
        catch (IOException iOException) {
            this.log(iOException.getMessage(), 4);
            throw new BuildException(iOException);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void setEntry(ZipEntry zipEntry) {
        if (zipEntry == null) {
            this.setExists(false);
            return;
        }
        this.setName(zipEntry.getName());
        this.setExists(true);
        this.setLastModified(zipEntry.getTime());
        this.setDirectory(zipEntry.isDirectory());
        this.setSize(zipEntry.getSize());
        this.setMode(zipEntry.getUnixMode());
    }
}

