/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.util.FileUtils;

public class URLResource
extends Resource {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final int NULL_URL = Resource.getMagicNumber("null URL".getBytes());
    private URL url;
    private URLConnection conn;

    public URLResource() {
    }

    public URLResource(URL uRL) {
        this.setURL(uRL);
    }

    public URLResource(File file) {
        this.setFile(file);
    }

    public URLResource(String string) {
        this(URLResource.newURL(string));
    }

    public synchronized void setURL(URL uRL) {
        this.checkAttributesAllowed();
        this.url = uRL;
    }

    public synchronized void setFile(File file) {
        try {
            this.setURL(FILE_UTILS.getFileURL(file));
        }
        catch (MalformedURLException malformedURLException) {
            throw new BuildException(malformedURLException);
        }
    }

    public synchronized URL getURL() {
        if (this.isReference()) {
            return ((URLResource)this.getCheckedRef()).getURL();
        }
        return this.url;
    }

    @Override
    public synchronized void setRefid(Reference reference) {
        if (this.url != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    @Override
    public synchronized String getName() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getName();
        }
        String string = this.getURL().getFile();
        return "".equals(string) ? string : string.substring(1);
    }

    @Override
    public synchronized String toString() {
        return this.isReference() ? this.getCheckedRef().toString() : String.valueOf(this.getURL());
    }

    @Override
    public synchronized boolean isExists() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).isExists();
        }
        return this.isExists(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean isExists(boolean bl) {
        if (this.getURL() == null) {
            return false;
        }
        try {
            this.connect();
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (bl) {
                this.close();
            }
        }
    }

    @Override
    public synchronized long getLastModified() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getLastModified();
        }
        if (!this.isExists(false)) {
            return 0L;
        }
        return this.conn.getLastModified();
    }

    @Override
    public synchronized boolean isDirectory() {
        return this.isReference() ? ((Resource)this.getCheckedRef()).isDirectory() : this.getName().endsWith("/");
    }

    @Override
    public synchronized long getSize() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getSize();
        }
        if (!this.isExists(false)) {
            return 0L;
        }
        try {
            this.connect();
            long l = this.conn.getContentLength();
            this.close();
            return l;
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.isReference()) {
            return this.getCheckedRef().equals(object);
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        URLResource uRLResource = (URLResource)object;
        return this.getURL() == null ? uRLResource.getURL() == null : this.getURL().equals(uRLResource.getURL());
    }

    @Override
    public synchronized int hashCode() {
        if (this.isReference()) {
            return this.getCheckedRef().hashCode();
        }
        return MAGIC * (this.getURL() == null ? NULL_URL : this.getURL().hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getInputStream();
        }
        this.connect();
        try {
            InputStream inputStream = this.conn.getInputStream();
            return inputStream;
        }
        finally {
            this.conn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getOutputStream();
        }
        this.connect();
        try {
            OutputStream outputStream = this.conn.getOutputStream();
            return outputStream;
        }
        finally {
            this.conn = null;
        }
    }

    protected synchronized void connect() throws IOException {
        URL uRL = this.getURL();
        if (uRL == null) {
            throw new BuildException("URL not set");
        }
        if (this.conn == null) {
            try {
                this.conn = uRL.openConnection();
                this.conn.connect();
            }
            catch (IOException iOException) {
                this.log(iOException.toString(), 0);
                this.conn = null;
                throw iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void close() {
        if (this.conn != null) {
            try {
                if (this.conn instanceof JarURLConnection) {
                    JarURLConnection jarURLConnection = (JarURLConnection)this.conn;
                    JarFile jarFile = jarURLConnection.getJarFile();
                    jarFile.close();
                    jarFile = null;
                } else if (this.conn instanceof HttpURLConnection) {
                    ((HttpURLConnection)this.conn).disconnect();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.conn = null;
            }
        }
    }

    private static URL newURL(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new BuildException(malformedURLException);
        }
    }
}

