/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.ImmutableResourceException;

public class StringResource
extends Resource {
    private static final int STRING_MAGIC = Resource.getMagicNumber("StringResource".getBytes());
    private String encoding = null;

    public StringResource() {
    }

    public StringResource(String string) {
        this(null, string);
    }

    public StringResource(Project project, String string) {
        this.setProject(project);
        this.setValue(project == null ? string : project.replaceProperties(string));
    }

    @Override
    public synchronized void setName(String string) {
        if (this.getName() != null) {
            throw new BuildException(new ImmutableResourceException());
        }
        super.setName(string);
    }

    public synchronized void setValue(String string) {
        this.setName(string);
    }

    @Override
    public synchronized String getName() {
        return super.getName();
    }

    public synchronized String getValue() {
        return this.getName();
    }

    @Override
    public boolean isExists() {
        return this.getValue() != null;
    }

    public void addText(String string) {
        this.checkChildrenAllowed();
        this.setValue(this.getProject().replaceProperties(string));
    }

    public synchronized void setEncoding(String string) {
        this.checkAttributesAllowed();
        this.encoding = string;
    }

    public synchronized String getEncoding() {
        return this.encoding;
    }

    @Override
    public synchronized long getSize() {
        return this.isReference() ? ((Resource)this.getCheckedRef()).getSize() : (long)this.getContent().length();
    }

    @Override
    public synchronized int hashCode() {
        if (this.isReference()) {
            return this.getCheckedRef().hashCode();
        }
        return super.hashCode() * STRING_MAGIC;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getContent());
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getInputStream();
        }
        String string = this.getContent();
        if (string == null) {
            throw new IllegalStateException("unset string value");
        }
        return new ByteArrayInputStream(this.encoding == null ? string.getBytes() : string.getBytes(this.encoding));
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getOutputStream();
        }
        if (this.getValue() != null) {
            throw new ImmutableResourceException();
        }
        return new StringResourceFilterOutputStream();
    }

    @Override
    public void setRefid(Reference reference) {
        if (this.encoding != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    protected synchronized String getContent() {
        return this.getValue();
    }

    private void setValueFromOutputStream(String string) {
        String string2 = this.getProject() != null ? this.getProject().replaceProperties(string) : string;
        this.setValue(string2);
    }

    private class StringResourceFilterOutputStream
    extends FilterOutputStream {
        private final ByteArrayOutputStream baos;

        public StringResourceFilterOutputStream() {
            super(new ByteArrayOutputStream());
            this.baos = (ByteArrayOutputStream)this.out;
        }

        @Override
        public void close() throws IOException {
            super.close();
            String string = StringResource.this.encoding == null ? this.baos.toString() : this.baos.toString(StringResource.this.encoding);
            StringResource.this.setValueFromOutputStream(string);
        }
    }
}

