/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.BaseResourceCollectionWrapper;
import org.apache.tools.ant.types.resources.FailFast;
import org.apache.tools.ant.types.resources.comparators.DelegatedResourceComparator;
import org.apache.tools.ant.types.resources.comparators.ResourceComparator;

public class Sort
extends BaseResourceCollectionWrapper {
    private DelegatedResourceComparator comp = new DelegatedResourceComparator();

    @Override
    protected synchronized Collection getCollection() {
        ResourceCollection resourceCollection = this.getResourceCollection();
        Iterator iterator = resourceCollection.iterator();
        if (!iterator.hasNext()) {
            return Collections.EMPTY_SET;
        }
        SortedBag sortedBag = new SortedBag(this.comp);
        while (iterator.hasNext()) {
            sortedBag.add(iterator.next());
        }
        return sortedBag;
    }

    public synchronized void add(ResourceComparator resourceComparator) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.comp.add(resourceComparator);
        FailFast.invalidate(this);
    }

    @Override
    protected synchronized void dieOnCircularReference(Stack stack, Project project) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stack, project);
        } else {
            DataType.invokeCircularReferenceCheck(this.comp, stack, project);
            this.setChecked(true);
        }
    }

    private static class SortedBag
    extends AbstractCollection {
        private TreeMap t;
        private int size;

        SortedBag(Comparator comparator) {
            this.t = new TreeMap(comparator);
        }

        @Override
        public synchronized Iterator iterator() {
            return new MyIterator();
        }

        @Override
        public synchronized boolean add(Object object) {
            MutableInt mutableInt;
            if (this.size < Integer.MAX_VALUE) {
                ++this.size;
            }
            if ((mutableInt = (MutableInt)this.t.get(object)) == null) {
                mutableInt = new MutableInt();
                this.t.put(object, mutableInt);
            }
            mutableInt.value++;
            return true;
        }

        @Override
        public synchronized int size() {
            return this.size;
        }

        private class MyIterator
        implements Iterator {
            private Iterator keyIter;
            private Object current;
            private int occurrence;

            private MyIterator() {
                this.keyIter = SortedBag.this.t.keySet().iterator();
            }

            @Override
            public synchronized boolean hasNext() {
                return this.occurrence > 0 || this.keyIter.hasNext();
            }

            public synchronized Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.occurrence == 0) {
                    this.current = this.keyIter.next();
                    this.occurrence = ((MutableInt)SortedBag.this.t.get(this.current)).value;
                }
                --this.occurrence;
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        private class MutableInt {
            private int value = 0;

            private MutableInt() {
            }
        }
    }
}

