/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.util.FileUtils;

public class JavaResource
extends Resource {
    private Path classpath;
    private Reference loader;

    public JavaResource() {
    }

    public JavaResource(String string, Path path) {
        this.setName(string);
        this.classpath = path;
    }

    public void setClasspath(Path path) {
        this.checkAttributesAllowed();
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        this.checkChildrenAllowed();
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.checkAttributesAllowed();
        this.createClasspath().setRefid(reference);
    }

    public Path getClasspath() {
        return this.isReference() ? ((JavaResource)this.getCheckedRef()).getClasspath() : this.classpath;
    }

    public void setLoaderRef(Reference reference) {
        this.checkAttributesAllowed();
        this.loader = reference;
    }

    @Override
    public void setRefid(Reference reference) {
        if (this.loader != null || this.classpath != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExists() {
        boolean bl;
        InputStream inputStream = null;
        try {
            bl = this.isReference() ? ((Resource)this.getCheckedRef()).isExists() : (inputStream = this.getInputStream()) != null;
        }
        catch (IOException iOException) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                FileUtils.close(inputStream);
                throw throwable;
            }
            FileUtils.close(inputStream);
            return bl2;
        }
        FileUtils.close(inputStream);
        return bl;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getInputStream();
        }
        ClassLoader classLoader = null;
        if (this.loader != null) {
            classLoader = (ClassLoader)this.loader.getReferencedObject();
        }
        if (classLoader == null) {
            classLoader = this.getClasspath() != null ? this.getProject().createClassLoader(this.classpath) : JavaResource.class.getClassLoader();
            if (this.loader != null && classLoader != null) {
                this.getProject().addReference(this.loader.getRefId(), classLoader);
            }
        }
        return classLoader == null ? ClassLoader.getSystemResourceAsStream(this.getName()) : classLoader.getResourceAsStream(this.getName());
    }

    @Override
    public int compareTo(Object object) {
        if (this.isReference()) {
            return ((Comparable)this.getCheckedRef()).compareTo(object);
        }
        if (object.getClass().equals(this.getClass())) {
            Path path;
            JavaResource javaResource = (JavaResource)object;
            if (!this.getName().equals(javaResource.getName())) {
                return this.getName().compareTo(javaResource.getName());
            }
            if (this.loader != javaResource.loader) {
                if (this.loader == null) {
                    return -1;
                }
                if (javaResource.loader == null) {
                    return 1;
                }
                return this.loader.getRefId().compareTo(javaResource.loader.getRefId());
            }
            Path path2 = this.getClasspath();
            if (path2 != (path = javaResource.getClasspath())) {
                if (path2 == null) {
                    return -1;
                }
                if (path == null) {
                    return 1;
                }
                return path2.toString().compareTo(path.toString());
            }
            return 0;
        }
        return super.compareTo(object);
    }
}

